/*
 * Decompiled with CFR 0.152.
 */
package reloc.org.sat4j.minisat.core;

import reloc.org.sat4j.annotations.Feature;
import reloc.org.sat4j.minisat.core.ConflictTimer;
import reloc.org.sat4j.minisat.core.DataStructureFactory;
import reloc.org.sat4j.minisat.core.LearnedConstraintsDeletionStrategy;
import reloc.org.sat4j.minisat.core.Solver;
import reloc.org.sat4j.specs.Constr;
import reloc.org.sat4j.specs.IVec;

@Feature(value="deletion", parent="expert")
final class AgeLCDS
implements LearnedConstraintsDeletionStrategy {
    private static final long serialVersionUID = 1L;
    private final ConflictTimer timer;
    private final Solver<? extends DataStructureFactory> solver;

    AgeLCDS(Solver<? extends DataStructureFactory> solver, ConflictTimer timer) {
        this.timer = timer;
        this.solver = solver;
    }

    @Override
    public void reduce(IVec<Constr> learnedConstrs) {
        int i;
        int j = 0;
        for (i = 0; i < this.solver.learnts.size() / 2; ++i) {
            Constr c = this.solver.learnts.get(i);
            if (c.locked() || c.size() == 2) {
                this.solver.learnts.set(j++, this.solver.learnts.get(i));
                continue;
            }
            c.remove(this.solver);
            this.solver.slistener.delete(c);
        }
        while (i < this.solver.learnts.size()) {
            this.solver.learnts.set(j++, this.solver.learnts.get(i));
            ++i;
        }
        if (this.solver.isVerbose()) {
            this.solver.out.log(this.solver.getLogPrefix() + "cleaning " + (this.solver.learnts.size() - j) + " clauses out of " + this.solver.learnts.size());
        }
        this.solver.learnts.shrinkTo(j);
    }

    @Override
    public ConflictTimer getTimer() {
        return this.timer;
    }

    public String toString() {
        return "Age based learned constraints deletion strategy with timer " + this.timer;
    }

    @Override
    public void init() {
    }

    @Override
    public void onClauseLearning(Constr constr) {
    }

    @Override
    public void onConflictAnalysis(Constr reason) {
    }

    @Override
    public void onPropagation(Constr from, int propagated) {
    }
}

