/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.operation.param;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Consumer;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.sinytra.adapter.patch.analysis.MethodCallAnalyzer;
import org.sinytra.adapter.patch.analysis.selector.AnnotationHandle;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.util.AdapterUtil;
import org.sinytra.adapter.patch.util.MethodQualifier;

public final class ParamTransformationUtil {
    private static final MethodQualifier WO_ORIGINAL_CALL = new MethodQualifier("Lcom/llamalad7/mixinextras/injector/wrapoperation/Operation;", "call", "([Ljava/lang/Object;)Ljava/lang/Object;");

    public static int calculateLVTIndex(List<Type> parameters, boolean nonStatic, int index) {
        int lvt = nonStatic ? 1 : 0;
        for (int i = 0; i < index; ++i) {
            lvt += parameters.get(i).getSize();
        }
        return lvt;
    }

    public static List<AbstractInsnNode> findWrapOperationOriginalCall(MethodNode methodNode, MethodContext methodContext) {
        if (methodContext.methodAnnotation().matchesDesc("Lcom/llamalad7/mixinextras/injector/wrapoperation/WrapOperation;")) {
            ArrayList<AbstractInsnNode> list = new ArrayList<AbstractInsnNode>();
            for (AbstractInsnNode insn : methodNode.instructions) {
                MethodInsnNode minsn;
                if (!(insn instanceof MethodInsnNode) || !WO_ORIGINAL_CALL.matches(minsn = (MethodInsnNode)insn)) continue;
                for (AbstractInsnNode prev = insn.getPrevious(); prev != null && !(prev instanceof LabelNode); prev = prev.getPrevious()) {
                    if (!AdapterUtil.canHandleLocalVarInsnValue(prev)) continue;
                    list.add(prev);
                }
            }
            return List.copyOf(list);
        }
        return List.of();
    }

    public static List<AbstractInsnNode> findWrapOperationOriginalCallArgs(MethodNode methodNode, MethodContext methodContext) {
        if (methodContext.methodAnnotation().matchesDesc("Lcom/llamalad7/mixinextras/injector/wrapoperation/WrapOperation;")) {
            for (AbstractInsnNode insn : methodNode.instructions) {
                MethodInsnNode minsn;
                if (!(insn instanceof MethodInsnNode) || !WO_ORIGINAL_CALL.matches(minsn = (MethodInsnNode)insn)) continue;
                return MethodCallAnalyzer.findFullMethodCallParamInsns(methodNode, minsn);
            }
        }
        return List.of();
    }

    public static void extractWrapOperation(MethodContext methodContext, MethodNode methodNode, List<Type> params, Consumer<WrapOpModification> modification) {
        int i;
        AnnotationHandle annotation = methodContext.methodAnnotation();
        if (!annotation.matchesDesc("Lcom/llamalad7/mixinextras/injector/wrapoperation/WrapOperation;")) {
            return;
        }
        int wrapOpIndex = -1;
        for (int i2 = 0; i2 < params.size(); ++i2) {
            if (!params.get(i2).getInternalName().equals("com/llamalad7/mixinextras/injector/wrapoperation/Operation")) continue;
            wrapOpIndex = i2;
            break;
        }
        if (wrapOpIndex < 0) {
            return;
        }
        boolean isNonStatic = (methodNode.access & 8) == 0;
        int wrapOpLvt = isNonStatic ? 1 : 0;
        for (i = 0; i < wrapOpIndex; ++i) {
            wrapOpLvt += params.get(i).getSize();
        }
        for (i = 0; i < methodNode.instructions.size(); ++i) {
            TypeInsnNode n;
            VarInsnNode vin;
            MethodInsnNode minsn;
            AbstractInsnNode insn = methodNode.instructions.get(i);
            if (!(insn instanceof MethodInsnNode) || !WO_ORIGINAL_CALL.matches(minsn = (MethodInsnNode)insn)) continue;
            int loadInsnIndex = -1;
            for (int j = i - 1; j >= 0; --j) {
                AbstractInsnNode abstractInsnNode = methodNode.instructions.get(j);
                if (!(abstractInsnNode instanceof VarInsnNode)) continue;
                vin = (VarInsnNode)abstractInsnNode;
                if (vin.var != wrapOpLvt || vin.getOpcode() != 25) continue;
                loadInsnIndex = j;
                break;
            }
            if (loadInsnIndex == -1) {
                return;
            }
            if (!AdapterUtil.getIntConstValue(methodNode.instructions.get(loadInsnIndex + 1)).isPresent() || !((vin = methodNode.instructions.get(loadInsnIndex + 2)) instanceof TypeInsnNode) || (n = (TypeInsnNode)vin).getOpcode() != 189) {
                return;
            }
            IntArrayList removals = new IntArrayList();
            final HashMap<Integer, Consumer> insertions = new HashMap<Integer, Consumer>();
            final HashMap<Integer, Consumer> replacements = new HashMap<Integer, Consumer>();
            modification.accept(new WrapOpModification(){
                final /* synthetic */ IntList val$removals;
                {
                    this.val$removals = intList;
                }

                @Override
                public void insertParameter(int index, Consumer<InsnList> adapter) {
                    insertions.put(index, adapter);
                }

                @Override
                public void replaceParameter(int index, Consumer<InsnList> adapter) {
                    replacements.put(index, adapter);
                }

                @Override
                public void removeParameter(int index) {
                    this.val$removals.add(index);
                }
            });
            int oldArraySize = AdapterUtil.getIntConstValue(methodNode.instructions.get(loadInsnIndex + 1)).getAsInt();
            int newArrayLength = oldArraySize + insertions.size();
            methodNode.instructions.set(methodNode.instructions.get(loadInsnIndex + 1), AdapterUtil.getIntConstInsn(newArrayLength - removals.size()));
            List[] objects = new List[newArrayLength];
            for (int j = 0; j < newArrayLength; ++j) {
                objects[j] = new ArrayList();
            }
            int currentSequenceIndex = -1;
            for (int j = loadInsnIndex + 4; j < i; ++j) {
                AbstractInsnNode instruction = methodNode.instructions.get(j);
                OptionalInt possibleIdx = AdapterUtil.getIntConstValue(instruction);
                if (currentSequenceIndex == -1 && possibleIdx.isPresent()) {
                    currentSequenceIndex = possibleIdx.getAsInt();
                    continue;
                }
                if (currentSequenceIndex == -1) continue;
                if (instruction.getOpcode() == 83 && (methodNode.instructions.get(j + 1).getOpcode() == 89 || currentSequenceIndex + 1 == oldArraySize)) {
                    ++j;
                    currentSequenceIndex = -1;
                    continue;
                }
                objects[currentSequenceIndex].add(instruction);
            }
            int finalLoadInsnIndex = loadInsnIndex;
            insertions.forEach((position, target) -> {
                int lastOfPrevious;
                if (position > 0 && methodNode.instructions.get((lastOfPrevious = methodNode.instructions.indexOf((AbstractInsnNode)objects[position - 1].getLast())) + 2).getOpcode() != 89) {
                    methodNode.instructions.insert(methodNode.instructions.get(lastOfPrevious + 1), (AbstractInsnNode)new InsnNode(89));
                }
                if (!objects[position].isEmpty()) {
                    for (int j = newArrayLength - 1; j >= position; --j) {
                        objects[j] = objects[j - 1];
                        objects[j - 1] = new ArrayList();
                        if (objects[j].isEmpty()) continue;
                        methodNode.instructions.set(methodNode.instructions.get(methodNode.instructions.indexOf((AbstractInsnNode)objects[j].getFirst()) - 1), AdapterUtil.getIntConstInsn(j));
                    }
                }
                InsnList actualInstructions = new InsnList();
                actualInstructions.add(AdapterUtil.getIntConstInsn(position));
                InsnList sub = new InsnList();
                target.accept(sub);
                actualInstructions.add(sub);
                actualInstructions.add((AbstractInsnNode)new InsnNode(83));
                if (position < newArrayLength - 1) {
                    actualInstructions.add((AbstractInsnNode)new InsnNode(89));
                }
                int insertionTarget = position == 0 ? finalLoadInsnIndex + 3 : methodNode.instructions.indexOf((AbstractInsnNode)objects[position - 1].getLast()) + 2;
                methodNode.instructions.insert(methodNode.instructions.get(insertionTarget), actualInstructions);
                sub.forEach(objects[position]::add);
            });
            replacements.forEach((position, cons) -> {
                if (objects[position].isEmpty()) {
                    return;
                }
                InsnList actualInstructions = new InsnList();
                actualInstructions.add(AdapterUtil.getIntConstInsn(position));
                InsnList sub = new InsnList();
                cons.accept(sub);
                actualInstructions.add(sub);
                actualInstructions.add((AbstractInsnNode)new InsnNode(58));
                actualInstructions.add((AbstractInsnNode)new InsnNode(89));
                AbstractInsnNode target = methodNode.instructions.get(methodNode.instructions.indexOf((AbstractInsnNode)objects[position].getFirst()) - 1);
                objects[position].forEach(arg_0 -> ((InsnList)methodNode.instructions).remove(arg_0));
                objects[position].clear();
                methodNode.instructions.insert(target, actualInstructions);
                sub.forEach(objects[position]::add);
            });
            removals.forEach(position -> {
                int lastOfPrevious;
                List toRemove = objects[position];
                for (int j = position + 1; j < newArrayLength; ++j) {
                    objects[j - 1] = objects[j];
                    if (objects[j - 1].isEmpty()) continue;
                    methodNode.instructions.set(methodNode.instructions.get(methodNode.instructions.indexOf((AbstractInsnNode)objects[j - 1].getFirst()) - 1), AdapterUtil.getIntConstInsn(j - 1));
                }
                AbstractInsnNode dup = methodNode.instructions.get(methodNode.instructions.indexOf((AbstractInsnNode)toRemove.getLast()) + 2);
                List.of(methodNode.instructions.get(methodNode.instructions.indexOf((AbstractInsnNode)toRemove.getFirst()) - 1), methodNode.instructions.get(methodNode.instructions.indexOf((AbstractInsnNode)toRemove.getLast()) + 1)).forEach(arg_0 -> ((InsnList)methodNode.instructions).remove(arg_0));
                toRemove.forEach(arg_0 -> ((InsnList)methodNode.instructions).remove(arg_0));
                if (dup.getOpcode() == 89) {
                    methodNode.instructions.remove(dup);
                }
                if (position > 0 && !objects[position - 1].isEmpty() && methodNode.instructions.get((lastOfPrevious = methodNode.instructions.indexOf((AbstractInsnNode)objects[position - 1].getLast())) + 2).getOpcode() == 89) {
                    methodNode.instructions.remove(methodNode.instructions.get(lastOfPrevious + 2));
                }
            });
            i = methodNode.instructions.indexOf((AbstractInsnNode)minsn);
        }
    }

    public static interface WrapOpModification {
        public void insertParameter(int var1, Consumer<InsnList> var2);

        public void replaceParameter(int var1, Consumer<InsnList> var2);

        public void removeParameter(int var1);
    }
}

