/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.dynfix;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.sinytra.adapter.patch.analysis.InstructionMatcher;
import org.sinytra.adapter.patch.analysis.MethodCallAnalyzer;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.PatchAuditTrail;
import org.sinytra.adapter.patch.transformer.dynfix.DynamicFixer;
import org.sinytra.adapter.patch.transformer.operation.DisableMixin;
import org.sinytra.adapter.patch.transformer.operation.ModifyMixinType;

public class DynFixSyntheticInstanceof
implements DynamicFixer<Data> {
    private static final Set<String> ACCEPTED_ANNOTATIONS = Set.of("Lorg/spongepowered/asm/mixin/injection/Redirect;", "Lcom/llamalad7/mixinextras/injector/ModifyExpressionValue;");
    private static final int RANGE = 4;

    @Override
    @Nullable
    public Data prepare(MethodContext methodContext) {
        if (methodContext.methodAnnotation().matchesAny(ACCEPTED_ANNOTATIONS) && methodContext.hasInjectionPointValue("INVOKE") && methodContext.findCleanInjectionTarget() != null && methodContext.findDirtyInjectionTarget() != null) {
            List<AbstractInsnNode> insns = methodContext.findInjectionTargetInsns(methodContext.findCleanInjectionTarget());
            return new Data(insns.getFirst());
        }
        return null;
    }

    @Override
    @Nullable
    public DynamicFixer.FixResult apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchAuditTrail auditTrail, Data data) {
        AbstractInsnNode targetInsn = data.cleanInjectionInsn();
        List<AbstractInsnNode> labelInsns = DynFixSyntheticInstanceof.findLabelInsns(targetInsn);
        AbstractInsnNode jumpInsn = labelInsns.getLast();
        if (!(jumpInsn instanceof JumpInsnNode)) {
            return null;
        }
        InstructionMatcher cleanMatcher = MethodCallAnalyzer.findForwardInstructions(targetInsn, 4);
        int firstOp = cleanMatcher.after().getFirst().getOpcode();
        InsnList dirtyInsns = methodContext.findDirtyInjectionTarget().methodNode().instructions;
        for (AbstractInsnNode insn : dirtyInsns) {
            InstructionMatcher finalDirtyMatcher;
            AbstractInsnNode nextLabel;
            InstructionMatcher dirtyMatcher;
            if (insn.getOpcode() != firstOp || !cleanMatcher.test(dirtyMatcher = MethodCallAnalyzer.findForwardInstructions(nextLabel = DynFixSyntheticInstanceof.findInsnAfterLabel(insn), 4))) continue;
            if (methodContext.methodAnnotation().matchesDesc("Lcom/llamalad7/mixinextras/injector/ModifyExpressionValue;")) {
                TypeInsnNode instanceOfInsn = DynFixSyntheticInstanceof.findLabelInsns(insn).stream().filter(i -> i.getOpcode() == 193).findFirst().orElse(null);
                if (instanceOfInsn == null) {
                    return null;
                }
                ModifyMixinType transform = new ModifyMixinType("Lorg/sinytra/adapter/runtime/inject/ModifyInstanceofValue;", b -> {
                    b.sameTarget().injectionPoint("sinytra:INSTANCEOF", instanceOfInsn.desc);
                    int ordinal = DynFixSyntheticInstanceof.getInstanceofOrdinal(dirtyInsns, (AbstractInsnNode)instanceOfInsn);
                    if (ordinal != 0) {
                        b.putValue("ordinal", ordinal);
                    }
                });
                return DynamicFixer.FixResult.of(transform.apply(methodContext), PatchAuditTrail.Match.FULL);
            }
            List<AbstractInsnNode> dirtyLabelInsns = DynFixSyntheticInstanceof.findLabelInsns(insn);
            ArrayList<AbstractInsnNode> modLabelInsns = new ArrayList<AbstractInsnNode>();
            for (AbstractInsnNode ins : methodNode.instructions) {
                if (ins instanceof LineNumberNode || ins instanceof FrameNode) continue;
                modLabelInsns.add(ins.clone(Map.of()));
            }
            modLabelInsns.removeFirst();
            modLabelInsns.removeLast();
            dirtyLabelInsns.removeLast();
            modLabelInsns.removeLast();
            InstructionMatcher finalCleanMatcher = new InstructionMatcher(null, dirtyLabelInsns, List.of());
            if (!finalCleanMatcher.test(finalDirtyMatcher = new InstructionMatcher(null, modLabelInsns, List.of()), 1)) continue;
            return DynamicFixer.FixResult.of(new DisableMixin().apply(methodContext), PatchAuditTrail.Match.PARTIAL);
        }
        return null;
    }

    private static AbstractInsnNode findInsnAfterLabel(AbstractInsnNode insn) {
        AbstractInsnNode next;
        for (next = insn.getNext(); next != null && !(next instanceof LabelNode); next = next.getNext()) {
        }
        return next;
    }

    private static List<AbstractInsnNode> findLabelInsns(AbstractInsnNode insn) {
        ArrayList<AbstractInsnNode> list = new ArrayList<AbstractInsnNode>();
        if (!(insn instanceof LabelNode)) {
            for (AbstractInsnNode prev = insn.getPrevious(); prev != null && !(prev instanceof LabelNode); prev = prev.getPrevious()) {
                if (prev instanceof FrameNode || prev instanceof LineNumberNode) continue;
                list.add(prev);
            }
        }
        for (AbstractInsnNode next = insn.getNext(); next != null && !(next instanceof LabelNode); next = next.getNext()) {
            if (next instanceof FrameNode || next instanceof LineNumberNode) continue;
            list.add(next);
        }
        return list;
    }

    private static int getInstanceofOrdinal(InsnList insns, AbstractInsnNode insn) {
        ArrayList<AbstractInsnNode> instanceOfInsns = new ArrayList<AbstractInsnNode>();
        for (AbstractInsnNode node : insns) {
            if (node.getOpcode() != 193) continue;
            instanceOfInsns.add(insn);
        }
        return instanceOfInsns.indexOf(insn);
    }

    public record Data(AbstractInsnNode cleanInjectionInsn) {
    }
}

