/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.datagen.betterend.worldgen.features;

import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.betterx.betterend.complexmaterials.StoneMaterial;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndFeatures;
import org.betterx.betterend.registry.features.EndOreFeatures;
import org.betterx.betterend.world.features.terrain.OreLayerFeatureConfig;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.provider.multi.WoverFeatureProvider;
import org.betterx.wover.feature.api.placed.PlacedFeatureKey;
import org.jetbrains.annotations.NotNull;

public class OreFeatureProvider
extends WoverFeatureProvider {
    public OreFeatureProvider(@NotNull ModCore modCore) {
        super(modCore, modCore.id("ores"));
    }

    protected void bootstrapConfigured(BootstrapContext<ConfiguredFeature<?, ?>> context) {
    }

    protected void bootstrapPlaced(BootstrapContext<PlacedFeature> context) {
        this.registerOre(context, EndOreFeatures.THALLASIUM_ORE, EndBlocks.THALLASIUM.ore, 24, 8);
        this.registerOre(context, EndOreFeatures.ENDER_ORE, EndBlocks.ENDER_ORE, 12, 4);
        this.registerOre(context, EndOreFeatures.AMBER_ORE, EndBlocks.AMBER_ORE, 60, 6);
        this.registerOre(context, EndOreFeatures.DRAGON_BONE_BLOCK_ORE, EndBlocks.DRAGON_BONE_BLOCK, 24, 8);
        OreFeatureProvider.registerLayer(context, EndOreFeatures.VIOLECITE_LAYER, EndBlocks.VIOLECITE, 15.0f, 16, 128, 8);
        OreFeatureProvider.registerLayer(context, EndOreFeatures.FLAVOLITE_LAYER, EndBlocks.FLAVOLITE, 12.0f, 16, 128, 6);
    }

    private void registerOre(BootstrapContext<PlacedFeature> context, PlacedFeatureKey key, Block blockOre, int veins, int veinSize) {
        key.inlineConfiguration(context).ore().add(Blocks.END_STONE, blockOre).veinSize(veinSize).discardChanceOnAirExposure(0.0f).inlinePlace().count(veins).randomHeight8FromFloorCeil().squarePlacement().onlyInBiome().register();
    }

    private static void registerLayer(BootstrapContext<PlacedFeature> context, PlacedFeatureKey key, Block block, float radius, int minY, int maxY, int count) {
        key.inlineConfiguration(context).withFeature((Feature)EndFeatures.LAYERED_ORE_FEATURE).configuration((FeatureConfiguration)new OreLayerFeatureConfig(block.defaultBlockState(), radius, minY, maxY)).inlinePlace().onlyInBiome().count(count).register();
    }

    private static void registerLayer(BootstrapContext<PlacedFeature> context, PlacedFeatureKey key, StoneMaterial material, float radius, int minY, int maxY, int count) {
        OreFeatureProvider.registerLayer(context, key, material.stone, radius, minY, maxY, count);
    }
}

