/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.datagen.betterend.tags;

import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.betterx.bclib.api.v2.ComposterAPI;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.complexmaterials.MaterialManager;
import org.betterx.betterend.item.tool.EndHammerItem;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndItems;
import org.betterx.betterend.registry.EndTags;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.WoverTagProvider;
import org.betterx.wover.tag.api.TagManager;
import org.betterx.wover.tag.api.event.context.ItemTagBootstrapContext;
import org.betterx.wover.tag.api.predefined.CommonItemTags;

public class ItemTagProvider
extends WoverTagProvider.ForItems {
    public static final TagKey<Item> CAPE_SLOT = TagManager.ITEMS.makeTag(BetterEnd.TRINKETS_CORE, "chest/cape");

    public ItemTagProvider(ModCore modCore) {
        super(modCore);
    }

    public void prepareTags(ItemTagBootstrapContext context) {
        EndItems.getModItems().forEach(item -> {
            FoodProperties food = (FoodProperties)item.components().get(DataComponents.FOOD);
            if (food != null) {
                float compost = (float)food.nutrition() * food.saturation() * 0.18f;
                ComposterAPI.allowCompost((float)compost, (Item)item);
            }
            if (item instanceof EndHammerItem) {
                context.add(CommonItemTags.HAMMERS, (Object[])new Item[]{item});
            }
        });
        context.add(ItemTags.BEACON_PAYMENT_ITEMS, (Object[])new Item[]{EndItems.AETERNIUM_INGOT});
        context.add(CommonItemTags.IRON_INGOTS, (Object[])new Item[]{EndBlocks.THALLASIUM.ingot});
        context.add(EndTags.ALLOYING_IRON, (Object[])new Item[]{Items.IRON_ORE, Items.DEEPSLATE_IRON_ORE, Items.RAW_IRON});
        context.add(EndTags.ALLOYING_GOLD, (Object[])new Item[]{Items.GOLD_ORE, Items.DEEPSLATE_GOLD_ORE, Items.RAW_GOLD});
        context.add(EndTags.ALLOYING_COPPER, (Object[])new Item[]{Items.COPPER_ORE, Items.DEEPSLATE_COPPER_ORE, Items.RAW_COPPER});
        context.add(ItemTags.FISHES, (Object[])new Item[]{EndItems.END_FISH_RAW, EndItems.END_FISH_COOKED});
        context.add(EndTags.ANVIL_AETERNIUM_TOOL, (Object[])new Item[]{EndItems.AETERNIUM_HAMMER});
        context.add(EndTags.ANVIL_NETHERITE_TOOL, new TagKey[]{EndTags.ANVIL_AETERNIUM_TOOL});
        context.add(EndTags.ANVIL_NETHERITE_TOOL, (Object[])new Item[]{EndItems.NETHERITE_HAMMER});
        context.add(EndTags.ANVIL_DIAMOND_TOOL, new TagKey[]{EndTags.ANVIL_NETHERITE_TOOL});
        context.add(EndTags.ANVIL_DIAMOND_TOOL, (Object[])new Item[]{EndItems.DIAMOND_HAMMER, EndBlocks.TERMINITE.hammer});
        context.add(EndTags.ANVIL_IRON_TOOL, new TagKey[]{EndTags.ANVIL_DIAMOND_TOOL});
        context.add(EndTags.ANVIL_IRON_TOOL, (Object[])new Item[]{EndItems.IRON_HAMMER, EndItems.GOLDEN_HAMMER, EndBlocks.THALLASIUM.hammer});
        MaterialManager.stream().forEach(m -> m.registerItemTags(context));
        context.add(CAPE_SLOT, (Object[])new Item[]{EndItems.CRYSTALITE_ELYTRA, EndItems.ARMORED_ELYTRA});
    }
}

