/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.datagen.betterend.recipes;

import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.betterx.bclib.complexmaterials.WoodenComplexMaterial;
import org.betterx.betterend.registry.EndBiomes;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndItems;
import org.betterx.betterend.registry.EndTemplates;
import org.betterx.betterend.util.LootTableUtil;
import org.betterx.wover.biome.api.BiomeKey;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.provider.WoverLootTableProvider;
import org.jetbrains.annotations.NotNull;

public class EndChestLootTableProvider
extends WoverLootTableProvider {
    private static LootItemCondition.Builder IN_FOGGY_MUSHROOMLAND;
    private static LootItemCondition.Builder IN_CHORUS_FOREST;
    private static LootItemCondition.Builder IN_AMBER_LAND;
    private static LootItemCondition.Builder IN_GLOWING_GRASSLANDS;
    private static LootItemCondition.Builder IN_LANTERN_WOODS;
    private static LootItemCondition.Builder IN_MEGALAKE;
    private static LootItemCondition.Builder IN_MEGALAKE_GROVE;
    private static LootItemCondition.Builder IN_NEON_OASIS;
    private static LootItemCondition.Builder IN_SHADOW_FOREST;
    private static LootItemCondition.Builder IN_SULPHUR_SPRINGS;
    private static LootItemCondition.Builder IN_UMBRELLA_JUNGLE;

    public EndChestLootTableProvider(ModCore modCore) {
        super(modCore, LootContextParamSets.CHEST);
    }

    private LootPool.Builder fishing() {
        return LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndItems.END_FISH_RAW));
    }

    private LootPool.Builder fishingJunk() {
        LootPool.Builder builder = LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndItems.END_LILY_LEAF)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ENDER_PEARL)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CHORUS_FRUIT)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndItems.GELATINE)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndItems.CRYSTAL_SHARDS)).add(LootItem.lootTableItem((ItemLike)EndItems.HYDRALUX_PETAL).when(IN_SULPHUR_SPRINGS));
        EndChestLootTableProvider.addCharnia(builder);
        return builder;
    }

    private LootPool.Builder fishingTreasure(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.TERMINITE.swordBlade)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.TERMINITE.forgedPlate)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.MENGER_SPONGE)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BOW).apply((LootItemFunction.Builder)SetItemDamageFunction.setDamage((NumberProvider)UniformGenerator.between((float)0.0f, (float)0.25f))).apply((LootItemFunction.Builder)EnchantWithLevelsFunction.enchantWithLevels((HolderLookup.Provider)lookup, (NumberProvider)ConstantValue.exactly((float)30.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FISHING_ROD).apply((LootItemFunction.Builder)SetItemDamageFunction.setDamage((NumberProvider)UniformGenerator.between((float)0.0f, (float)0.25f))).apply((LootItemFunction.Builder)EnchantWithLevelsFunction.enchantWithLevels((HolderLookup.Provider)lookup, (NumberProvider)ConstantValue.exactly((float)30.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BOOK).apply((LootItemFunction.Builder)EnchantWithLevelsFunction.enchantWithLevels((HolderLookup.Provider)lookup, (NumberProvider)ConstantValue.exactly((float)30.0f))));
    }

    private LootPool.Builder foggyMushroomland() {
        return LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)4.0f, (float)8.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.MOSSY_GLOWSHROOM.getBlock(WoodenComplexMaterial.BLOCK_PLANKS))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.MOSSY_GLOWSHROOM_SAPLING)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.BLUE_VINE_SEED));
    }

    private LootPool.Builder chorusForest() {
        return LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)4.0f, (float)8.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.PYTHADENDRON.getBlock(WoodenComplexMaterial.BLOCK_PLANKS))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.PYTHADENDRON_SAPLING)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.CHORUS_MUSHROOM)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndTemplates.HANDLE_ATTACHMENT));
    }

    private LootPool.Builder shadowForest() {
        return LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)4.0f, (float)8.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.DRAGON_TREE.getBlock(WoodenComplexMaterial.BLOCK_PLANKS))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.DRAGON_TREE_SAPLING)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.SHADOW_BERRY)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndItems.SHADOW_BERRY_RAW));
    }

    private LootPool.Builder lanternWoods() {
        return LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)4.0f, (float)8.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.LUCERNIA.getBlock(WoodenComplexMaterial.BLOCK_PLANKS))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.LUCERNIA_SAPLING)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.BOLUX_MUSHROOM));
    }

    private LootPool.Builder umbrellaJungle() {
        return LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)4.0f, (float)8.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.UMBRELLA_TREE.getBlock(WoodenComplexMaterial.BLOCK_PLANKS))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.UMBRELLA_TREE_SAPLING)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.SMALL_JELLYSHROOM));
    }

    private LootPool.Builder upgradeLootPool() {
        return LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndTemplates.THALLASIUM_UPGRADE).setWeight(8).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndTemplates.TERMINITE_UPGRADE).setWeight(4).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndTemplates.AETERNIUM_UPGRADE).setWeight(2).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndTemplates.NETHERITE_UPGRADE).setWeight(8).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))));
    }

    private LootPool.Builder plateUpgradeLootPool() {
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)EndTemplates.PLATE_UPGRADE).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).when(LootItemRandomChanceCondition.randomChance((float)0.7f)));
    }

    private LootPool.Builder leatherHandleLootPool() {
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)EndTemplates.LEATHER_HANDLE_ATTACHMENT).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))).when(LootItemRandomChanceCondition.randomChance((float)0.75f)));
    }

    private LootPool.Builder handleLootPool() {
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndTemplates.HANDLE_ATTACHMENT).setWeight(8).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndTemplates.TOOL_ASSEMBLY).setWeight(2).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))));
    }

    private LootPool.Builder villageBonusLoot() {
        return LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndItems.AETERNIUM_INGOT).setWeight(8).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.FLAVOLITE_RUNED_ETERNAL).setWeight(4).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndItems.ETERNAL_CRYSTAL).setWeight(1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SHULKER_SHELL).setWeight(1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))));
    }

    private LootPool.Builder elytraLoot(float chance) {
        return LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ELYTRA).setWeight(1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FIREWORK_ROCKET).setWeight(8).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)8.0f)))).when(LootItemRandomChanceCondition.randomChance((float)chance));
    }

    private LootPool.Builder simpleVillageLoot() {
        return LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndItems.LEATHER_WRAPPED_STICK).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)5.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ENDER_PEARL).setWeight(9).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)5.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndItems.SHADOW_BERRY_COOKED).setWeight(8).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndItems.BLOSSOM_BERRY_JELLY).setWeight(4).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.THALLASIUM.shovelHead).setWeight(2).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Blocks.ENDER_CHEST).setWeight(1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))));
    }

    private static void addCharnia(LootPool.Builder pool) {
        pool.add(LootItem.lootTableItem((ItemLike)EndBlocks.CHARNIA_CYAN).when((LootItemCondition.Builder)IN_GLOWING_GRASSLANDS.or(IN_MEGALAKE).or(IN_MEGALAKE_GROVE).or(IN_NEON_OASIS)));
        pool.add(LootItem.lootTableItem((ItemLike)EndBlocks.CHARNIA_LIGHT_BLUE).when((LootItemCondition.Builder)IN_FOGGY_MUSHROOMLAND.or(IN_GLOWING_GRASSLANDS).or(IN_MEGALAKE).or(IN_MEGALAKE_GROVE).or(IN_UMBRELLA_JUNGLE)));
        pool.add(LootItem.lootTableItem((ItemLike)EndBlocks.CHARNIA_GREEN).when((LootItemCondition.Builder)IN_GLOWING_GRASSLANDS.or(IN_NEON_OASIS).or(IN_SULPHUR_SPRINGS).or(IN_UMBRELLA_JUNGLE)));
        pool.add(LootItem.lootTableItem((ItemLike)EndBlocks.CHARNIA_RED).when((LootItemCondition.Builder)IN_AMBER_LAND.or(IN_LANTERN_WOODS).or(IN_NEON_OASIS)));
        pool.add(LootItem.lootTableItem((ItemLike)EndBlocks.CHARNIA_ORANGE).when((LootItemCondition.Builder)IN_AMBER_LAND.or(IN_LANTERN_WOODS).or(IN_SULPHUR_SPRINGS)));
        pool.add(LootItem.lootTableItem((ItemLike)EndBlocks.CHARNIA_PURPLE).when((LootItemCondition.Builder)IN_CHORUS_FOREST.or(IN_SHADOW_FOREST)));
    }

    private static LootTable.Builder includeCommonItems(LootTable.Builder table) {
        LootPool.Builder builder = LootPool.lootPool();
        builder.setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f));
        builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndItems.MUSIC_DISC_STRANGE_AND_ALIEN));
        builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndItems.MUSIC_DISC_GRASPING_AT_STARS));
        builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndItems.MUSIC_DISC_ENDSEEKER));
        builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndItems.MUSIC_DISC_EO_DRACONA));
        table.withPool(builder);
        builder = LootPool.lootPool();
        builder.setRolls((NumberProvider)UniformGenerator.between((float)4.0f, (float)8.0f));
        builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.THALLASIUM.ingot));
        builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.THALLASIUM.rawOre));
        builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ENDER_PEARL));
        table.withPool(builder);
        builder = LootPool.lootPool();
        builder.setRolls((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f));
        builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.TERMINITE.ingot));
        builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndItems.ENDER_SHARD));
        builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.AURORA_CRYSTAL));
        builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.THALLASIUM.axe));
        builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.THALLASIUM.pickaxe));
        builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.THALLASIUM.hoe));
        builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.THALLASIUM.sword));
        builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.THALLASIUM.shovel));
        builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ENDER_EYE));
        builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Blocks.OBSIDIAN));
        table.withPool(builder);
        builder = LootPool.lootPool();
        builder.setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)4.0f));
        builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndBlocks.FLAVOLITE_RUNED));
        builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndItems.AETERNIUM_INGOT));
        builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndItems.AMBER_GEM));
        builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.END_CRYSTAL));
        builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GHAST_TEAR));
        table.withPool(builder);
        return table;
    }

    private static LootItemCondition.Builder biomePredicate(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup, BiomeKey<?> key) {
        HolderLookup.RegistryLookup biomeRegistry = lookup.lookupOrThrow(Registries.BIOME);
        Holder.Reference holder = biomeRegistry.get(key.key).orElse(null);
        return LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)HolderSet.direct((Holder[])new Holder[]{holder})));
    }

    protected void boostrap(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup, @NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> biConsumer) {
        IN_FOGGY_MUSHROOMLAND = EndChestLootTableProvider.biomePredicate(lookup, EndBiomes.FOGGY_MUSHROOMLAND);
        IN_CHORUS_FOREST = EndChestLootTableProvider.biomePredicate(lookup, EndBiomes.CHORUS_FOREST);
        IN_AMBER_LAND = EndChestLootTableProvider.biomePredicate(lookup, EndBiomes.AMBER_LAND);
        IN_GLOWING_GRASSLANDS = EndChestLootTableProvider.biomePredicate(lookup, EndBiomes.GLOWING_GRASSLANDS);
        IN_LANTERN_WOODS = EndChestLootTableProvider.biomePredicate(lookup, EndBiomes.LANTERN_WOODS);
        IN_MEGALAKE = EndChestLootTableProvider.biomePredicate(lookup, EndBiomes.MEGALAKE);
        IN_MEGALAKE_GROVE = EndChestLootTableProvider.biomePredicate(lookup, EndBiomes.MEGALAKE_GROVE);
        IN_NEON_OASIS = EndChestLootTableProvider.biomePredicate(lookup, EndBiomes.NEON_OASIS);
        IN_SHADOW_FOREST = EndChestLootTableProvider.biomePredicate(lookup, EndBiomes.SHADOW_FOREST);
        IN_SULPHUR_SPRINGS = EndChestLootTableProvider.biomePredicate(lookup, EndBiomes.SULPHUR_SPRINGS);
        IN_UMBRELLA_JUNGLE = EndChestLootTableProvider.biomePredicate(lookup, EndBiomes.UMBRELLA_JUNGLE);
        biConsumer.accept(LootTableUtil.VILLAGE_LOOT, LootTable.lootTable().withPool(this.simpleVillageLoot()).withPool(this.plateUpgradeLootPool()));
        biConsumer.accept(LootTableUtil.VILLAGE_TEMPLATE_LOOT, LootTable.lootTable().withPool(this.simpleVillageLoot()).withPool(this.handleLootPool()).withPool(this.leatherHandleLootPool()).withPool(this.plateUpgradeLootPool()).withPool(this.upgradeLootPool()));
        biConsumer.accept(LootTableUtil.VILLAGE_BONUS_LOOT, LootTable.lootTable().withPool(this.leatherHandleLootPool()).withPool(this.plateUpgradeLootPool()).withPool(this.villageBonusLoot()).withPool(this.elytraLoot(0.2f)));
        biConsumer.accept(LootTableUtil.FISHING_FISH, LootTable.lootTable().withPool(this.fishing()));
        biConsumer.accept(LootTableUtil.FISHING_JUNK, LootTable.lootTable().withPool(this.fishingJunk()));
        biConsumer.accept(LootTableUtil.FISHING_TREASURE, LootTable.lootTable().withPool(this.fishingTreasure(lookup)));
        biConsumer.accept(LootTableUtil.FOGGY_MUSHROOMLAND, EndChestLootTableProvider.includeCommonItems(LootTable.lootTable()).withPool(this.foggyMushroomland()));
        biConsumer.accept(LootTableUtil.CHORUS_FOREST, EndChestLootTableProvider.includeCommonItems(LootTable.lootTable()).withPool(this.chorusForest()));
        biConsumer.accept(LootTableUtil.SHADOW_FOREST, EndChestLootTableProvider.includeCommonItems(LootTable.lootTable()).withPool(this.shadowForest()));
        biConsumer.accept(LootTableUtil.LANTERN_WOODS, EndChestLootTableProvider.includeCommonItems(LootTable.lootTable()).withPool(this.lanternWoods()));
        biConsumer.accept(LootTableUtil.UMBRELLA_JUNGLE, EndChestLootTableProvider.includeCommonItems(LootTable.lootTable()).withPool(this.umbrellaJungle()));
        biConsumer.accept(LootTableUtil.BIOME_CHEST, EndChestLootTableProvider.includeCommonItems(LootTable.lootTable()).withPool(this.umbrellaJungle().when(IN_UMBRELLA_JUNGLE)).withPool(this.lanternWoods().when(IN_LANTERN_WOODS)).withPool(this.shadowForest().when(IN_SHADOW_FOREST)).withPool(this.chorusForest().when(IN_CHORUS_FOREST)).withPool(this.foggyMushroomland().when(IN_FOGGY_MUSHROOMLAND)));
        biConsumer.accept(LootTableUtil.COMMON, EndChestLootTableProvider.includeCommonItems(LootTable.lootTable()));
    }
}

