/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.datagen.betterend.advancement;

import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.ChangeDimensionTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.betterx.bclib.api.v2.advancement.AdvancementManager;
import org.betterx.bclib.api.v3.datagen.AdvancementDataProvider;
import org.betterx.bclib.complexmaterials.set.wood.WoodSlots;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.advancements.BECriteria;
import org.betterx.betterend.complexmaterials.MetalMaterial;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndItems;
import org.betterx.betterend.registry.EndStructures;
import org.betterx.betterend.registry.EndTemplates;

public class EndAdvancementDataProvider
extends AdvancementDataProvider {
    public EndAdvancementDataProvider(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registryLookup) {
        super(List.of(BetterEnd.MOD_ID), output, registryLookup);
    }

    protected void bootstrap(HolderLookup.Provider lookup) {
        HolderLookup.RegistryLookup structures = lookup.lookupOrThrow(Registries.STRUCTURE);
        HolderLookup.RegistryLookup biomeLookup = lookup.lookupOrThrow(Registries.BIOME);
        ResourceLocation root = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.C.mk("root")).startDisplay((ItemLike)EndBlocks.END_MYCELIUM).frame(AdvancementType.TASK).hideFromChat().background(ResourceLocation.withDefaultNamespace((String)"textures/gui/advancements/backgrounds/end.png")).endDisplay().addCriterion("welcome", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.location())).requirements(AdvancementRequirements.Strategy.OR).build();
        ResourceLocation enterEnd = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.C.mk("enter_end")).startDisplay((ItemLike)EndBlocks.CAVE_MOSS).endDisplay().parent(root).addCriterion("entered_end", ChangeDimensionTrigger.TriggerInstance.changedDimensionTo((ResourceKey)Level.END)).requirements(AdvancementRequirements.Strategy.OR).build();
        ResourceLocation portal = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.C.mk("portal")).parent(enterEnd).startDisplay((ItemLike)EndBlocks.ETERNAL_PEDESTAL).frame(AdvancementType.GOAL).endDisplay().addAtStructureCriterion("eternal_portal", EndStructures.ETERNAL_PORTAL.getHolder((HolderGetter)structures)).requirements(AdvancementRequirements.Strategy.OR).build();
        ResourceLocation portalOn = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.C.mk("portal_on")).parent(portal).startDisplay((ItemLike)EndItems.ETERNAL_CRYSTAL).endDisplay().addCriterion("turn_on", BECriteria.PORTAL_ON_TRIGGER).requirements(AdvancementRequirements.Strategy.OR).build();
        ResourceLocation portalTravel = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.C.mk("portal_travel")).parent(portalOn).startDisplay((ItemLike)Items.GRASS_BLOCK).frame(AdvancementType.CHALLENGE).endDisplay().addCriterion("travel", BECriteria.PORTAL_TRAVEL_TRIGGER).requirements(AdvancementRequirements.Strategy.OR).build();
        List<ResourceKey> biomes = biomeLookup.listElementIds().filter(id -> id.location().getNamespace().equals(BetterEnd.C.modId)).toList();
        if (!biomes.isEmpty()) {
            ResourceLocation allTheBiomes = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.C.mk("all_the_biomes")).parent(enterEnd).startDisplay((ItemLike)EndItems.AETERNIUM_BOOTS).frame(AdvancementType.CHALLENGE).endDisplay().addVisitBiomesCriterion(biomes.stream().sorted(Comparator.comparing(ResourceKey::location)).map(key -> (Holder)biomeLookup.get(key).orElseThrow()).toList()).requirements(AdvancementRequirements.Strategy.AND).rewardXP(1500).build();
            ResourceLocation resourceLocation = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.C.mk("village")).parent(allTheBiomes).startDisplay((ItemLike)EndBlocks.TENANEA.getBlock(WoodSlots.DOOR)).frame(AdvancementType.GOAL).endDisplay().addAtStructureCriterion("end_village", EndStructures.END_VILLAGE.getHolder((HolderGetter)structures)).requirements(AdvancementRequirements.Strategy.OR).build();
        }
        ResourceLocation allElytras = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.C.mk("all_elytras")).parent(enterEnd).startDisplay((ItemLike)EndItems.CRYSTALITE_ELYTRA).frame(AdvancementType.GOAL).endDisplay().addInventoryChangedCriterion("vanilla", new ItemLike[]{Items.ELYTRA}).addInventoryChangedCriterion("crystalite", new ItemLike[]{EndItems.CRYSTALITE_ELYTRA}).addInventoryChangedCriterion("armored", new ItemLike[]{EndItems.ARMORED_ELYTRA}).requirements(AdvancementRequirements.Strategy.AND).build();
        ResourceLocation infusion = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.C.mk("infusion")).parent(enterEnd).startDisplay((ItemLike)EndBlocks.INFUSION_PEDESTAL).endDisplay().addInventoryChangedCriterion("infusion_pedestal", new ItemLike[]{EndBlocks.INFUSION_PEDESTAL}).requirements(AdvancementRequirements.Strategy.OR).build();
        ResourceLocation infusionFinished = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.C.mk("infusion_finished")).parent(infusion).startDisplay((ItemLike)Items.ENDER_EYE).frame(AdvancementType.GOAL).endDisplay().addCriterion("finished", BECriteria.INFUSION_FINISHED_TRIGGER).requirements(AdvancementRequirements.Strategy.OR).build();
        ResourceLocation allTheTemplates = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.C.mk("all_the_templates")).parent(enterEnd).startDisplay((ItemLike)EndTemplates.TOOL_ASSEMBLY).frame(AdvancementType.CHALLENGE).endDisplay().addInventoryChangedAnyCriterion("got_handle", new ItemLike[]{EndTemplates.HANDLE_ATTACHMENT}).addInventoryChangedAnyCriterion("got_tool", new ItemLike[]{EndTemplates.TOOL_ASSEMBLY}).addInventoryChangedAnyCriterion("got_leather", new ItemLike[]{EndTemplates.LEATHER_HANDLE_ATTACHMENT}).addInventoryChangedAnyCriterion("got_plate", new ItemLike[]{EndTemplates.PLATE_UPGRADE}).addInventoryChangedAnyCriterion("got_terminite", new ItemLike[]{EndTemplates.TERMINITE_UPGRADE}).addInventoryChangedAnyCriterion("got_aeternium", new ItemLike[]{EndTemplates.AETERNIUM_UPGRADE}).addInventoryChangedAnyCriterion("got_thallasium", new ItemLike[]{EndTemplates.THALLASIUM_UPGRADE}).addInventoryChangedAnyCriterion("got_netherite", new ItemLike[]{EndTemplates.NETHERITE_UPGRADE}).requirements(AdvancementRequirements.Strategy.AND).rewardXP(1500).build();
        ResourceLocation hammer = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.C.mk("hammer")).parent(enterEnd).startDisplay((ItemLike)EndItems.DIAMOND_HAMMER).endDisplay().addInventoryChangedCriterion("got_diamond_hammer", new ItemLike[]{EndItems.DIAMOND_HAMMER}).addInventoryChangedCriterion("got_thallasium_hammer", new ItemLike[]{EndBlocks.THALLASIUM.hammer}).addInventoryChangedCriterion("got_terminite_hammer", new ItemLike[]{EndBlocks.TERMINITE.hammer}).requirements(AdvancementRequirements.Strategy.OR).build();
        ResourceLocation thallasiumAnvil = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.C.mk("thallasium_anvil")).parent(hammer).startDisplay((ItemLike)EndBlocks.THALLASIUM.anvilBlock).endDisplay().addInventoryChangedCriterion("got_thallasium_anvil", new ItemLike[]{EndBlocks.THALLASIUM.anvilBlock}).requirements(AdvancementRequirements.Strategy.OR).build();
        ResourceLocation thallasiumPlate = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.C.mk("thallasium_plate")).parent(thallasiumAnvil).startDisplay((ItemLike)EndBlocks.THALLASIUM.forgedPlate).endDisplay().addInventoryChangedCriterion("got_thallasium_plate", new ItemLike[]{EndBlocks.THALLASIUM.forgedPlate}).requirements(AdvancementRequirements.Strategy.OR).build();
        ResourceLocation terminiteAnvil = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.C.mk("terminite_anvil")).parent(thallasiumAnvil).startDisplay((ItemLike)EndBlocks.TERMINITE.anvilBlock).endDisplay().addInventoryChangedCriterion("got_terminite_anvil", new ItemLike[]{EndBlocks.TERMINITE.anvilBlock}).requirements(AdvancementRequirements.Strategy.OR).build();
        ResourceLocation terminitePlate = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.C.mk("terminite_plate")).parent(terminiteAnvil).startDisplay((ItemLike)EndBlocks.TERMINITE.forgedPlate).endDisplay().addInventoryChangedCriterion("got_erminite_plate", new ItemLike[]{EndBlocks.TERMINITE.forgedPlate}).requirements(AdvancementRequirements.Strategy.OR).build();
        ResourceLocation aeterniumAnvil = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.C.mk("aeternium_anvil")).parent(terminiteAnvil).startDisplay((ItemLike)EndBlocks.AETERNIUM_ANVIL).frame(AdvancementType.CHALLENGE).endDisplay().addInventoryChangedCriterion("got_aeternium_anvil", new ItemLike[]{EndBlocks.AETERNIUM_ANVIL}).requirements(AdvancementRequirements.Strategy.OR).rewardXP(500).build();
        ResourceLocation aeterniumHammerHead = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.C.mk("aeternium_hammer_head")).parent(aeterniumAnvil).startDisplay((ItemLike)EndItems.AETERNIUM_HAMMER_HEAD).endDisplay().addInventoryChangedCriterion("got_aeternium_hammer_head", new ItemLike[]{EndItems.AETERNIUM_HAMMER_HEAD}).requirements(AdvancementRequirements.Strategy.OR).build();
        ResourceLocation aeterniumHammer = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.C.mk("aeternium_hammer")).parent(aeterniumHammerHead).startDisplay((ItemLike)EndItems.AETERNIUM_HAMMER).endDisplay().addInventoryChangedCriterion("got_aeternium_hammer", new ItemLike[]{EndItems.AETERNIUM_HAMMER}).requirements(AdvancementRequirements.Strategy.OR).build();
        ResourceLocation aeterniumPlate = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.C.mk("aeternium_plate")).parent(aeterniumHammer).startDisplay((ItemLike)EndItems.AETERNIUM_FORGED_PLATE).frame(AdvancementType.GOAL).endDisplay().addInventoryChangedCriterion("got_aeternium_plate", new ItemLike[]{EndItems.AETERNIUM_FORGED_PLATE}).requirements(AdvancementRequirements.Strategy.OR).rewardXP(200).build();
        ResourceLocation thallasiumArmor = this.addArmor(EndBlocks.THALLASIUM).parent(thallasiumPlate).requirements(AdvancementRequirements.Strategy.OR).build();
        ResourceLocation thallasiumHead = this.addToolHeads(EndBlocks.THALLASIUM).parent(thallasiumAnvil).requirements(AdvancementRequirements.Strategy.OR).build();
        ResourceLocation thallasium = this.addTools(EndBlocks.THALLASIUM).parent(thallasiumHead).requirements(AdvancementRequirements.Strategy.OR).build();
        ResourceLocation terminiteHead = this.addToolHeads(EndBlocks.TERMINITE).parent(terminiteAnvil).requirements(AdvancementRequirements.Strategy.OR).build();
        ResourceLocation terminite = this.addTools(EndBlocks.TERMINITE).parent(terminiteHead).requirements(AdvancementRequirements.Strategy.OR).build();
        ResourceLocation terminiteArmor = this.addArmor(EndBlocks.TERMINITE).parent(terminitePlate).requirements(AdvancementRequirements.Strategy.OR).build();
        ResourceLocation aeterniumHead = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.C.mk("aeternium_tool_head")).startDisplay((ItemLike)EndItems.AETERNIUM_PICKAXE_HEAD).frame(AdvancementType.GOAL).endDisplay().parent(aeterniumHammer).addInventoryChangedCriterion("got_aeternium_pickaxe_head", new ItemLike[]{EndItems.AETERNIUM_PICKAXE_HEAD}).addInventoryChangedCriterion("got_aeternium_hoe_head", new ItemLike[]{EndItems.AETERNIUM_HOE_HEAD}).addInventoryChangedCriterion("got_aeternium_axe_head", new ItemLike[]{EndItems.AETERNIUM_AXE_HEAD}).addInventoryChangedCriterion("got_aeternium_shovel_head", new ItemLike[]{EndItems.AETERNIUM_SHOVEL_HEAD}).addInventoryChangedCriterion("got_aeternium_sword_head", new ItemLike[]{EndItems.AETERNIUM_SWORD_BLADE, EndItems.AETERNIUM_SWORD_HANDLE}).requirements(AdvancementRequirements.Strategy.AND).rewardXP(200).build();
        ResourceLocation aeternium = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.C.mk("aeternium_tool")).startDisplay((ItemLike)EndItems.AETERNIUM_PICKAXE).frame(AdvancementType.CHALLENGE).endDisplay().parent(aeterniumHead).addInventoryChangedCriterion("got_aeternium_pickaxe", new ItemLike[]{EndItems.AETERNIUM_PICKAXE}).addInventoryChangedCriterion("got_aeternium_hoe", new ItemLike[]{EndItems.AETERNIUM_HOE}).addInventoryChangedCriterion("got_aeternium_axe", new ItemLike[]{EndItems.AETERNIUM_AXE}).addInventoryChangedCriterion("got_aeternium_shovel", new ItemLike[]{EndItems.AETERNIUM_SHOVEL}).addInventoryChangedCriterion("got_aeternium_sword", new ItemLike[]{EndItems.AETERNIUM_SWORD}).requirements(AdvancementRequirements.Strategy.AND).rewardXP(2000).build();
        ResourceLocation aeterniumArmor = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.C.mk("aeternium_armor")).startDisplay((ItemLike)EndItems.AETERNIUM_CHESTPLATE).frame(AdvancementType.CHALLENGE).endDisplay().parent(aeterniumPlate).addInventoryChangedCriterion("got_aeternium_helmet", new ItemLike[]{EndItems.AETERNIUM_HELMET}).addInventoryChangedCriterion("got_aeternium_chestplate", new ItemLike[]{EndItems.AETERNIUM_CHESTPLATE}).addInventoryChangedCriterion("got_aeternium_leggings", new ItemLike[]{EndItems.AETERNIUM_LEGGINGS}).addInventoryChangedCriterion("got_aeternium_boots", new ItemLike[]{EndItems.AETERNIUM_BOOTS}).requirements(AdvancementRequirements.Strategy.AND).rewardXP(2000).build();
    }

    AdvancementManager.Builder addTools(MetalMaterial mat) {
        return AdvancementManager.Builder.create((ResourceLocation)BetterEnd.C.mk(mat.name + "_tool")).startDisplay((ItemLike)mat.pickaxe).endDisplay().addInventoryChangedCriterion("got_" + mat.name + "_pickaxe", new ItemLike[]{mat.pickaxe}).addInventoryChangedCriterion("got_" + mat.name + "_hoe", new ItemLike[]{mat.hoe}).addInventoryChangedCriterion("got_" + mat.name + "_axe", new ItemLike[]{mat.axe}).addInventoryChangedCriterion("got_" + mat.name + "_shovel", new ItemLike[]{mat.shovel}).addInventoryChangedCriterion("got_" + mat.name + "_sword", new ItemLike[]{mat.sword});
    }

    AdvancementManager.Builder addToolHeads(MetalMaterial mat) {
        return AdvancementManager.Builder.create((ResourceLocation)BetterEnd.C.mk(mat.name + "_tool_head")).startDisplay((ItemLike)mat.pickaxeHead).endDisplay().addInventoryChangedCriterion("got_" + mat.name + "_pickaxe_head", new ItemLike[]{mat.pickaxeHead}).addInventoryChangedCriterion("got_" + mat.name + "_hoe_head", new ItemLike[]{mat.hoeHead}).addInventoryChangedCriterion("got_" + mat.name + "_axe_head", new ItemLike[]{mat.axeHead}).addInventoryChangedCriterion("got_" + mat.name + "_shovel_head", new ItemLike[]{mat.shovelHead}).addInventoryChangedCriterion("got_" + mat.name + "_sword_head", new ItemLike[]{mat.swordBlade, mat.swordHandle});
    }

    AdvancementManager.Builder addArmor(MetalMaterial mat) {
        return AdvancementManager.Builder.create((ResourceLocation)BetterEnd.C.mk(mat.name + "_armor")).startDisplay((ItemLike)mat.chestplate).endDisplay().addInventoryChangedCriterion("got_" + mat.name + "_helmet", new ItemLike[]{mat.helmet}).addInventoryChangedCriterion("got_" + mat.name + "_chestplate", new ItemLike[]{mat.chestplate}).addInventoryChangedCriterion("got_" + mat.name + "_leggings", new ItemLike[]{mat.leggings}).addInventoryChangedCriterion("got_" + mat.name + "_boots", new ItemLike[]{mat.boots});
    }
}

