/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.structures.piece;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.registry.EndStructures;
import org.betterx.betterend.util.GlobalState;
import org.betterx.betterend.world.structures.piece.MountainPiece;

public class PaintedMountainPiece
extends MountainPiece {
    private BlockState[] slices;

    public PaintedMountainPiece(BlockPos center, float radius, float height, RandomSource random, Holder<Biome> biome, BlockState[] slices) {
        super(EndStructures.PAINTED_MOUNTAIN_PIECE, center, radius, height, random, biome);
        this.slices = slices;
    }

    public PaintedMountainPiece(StructurePieceSerializationContext type, CompoundTag tag) {
        super(EndStructures.PAINTED_MOUNTAIN_PIECE, tag);
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        ListTag slice = new ListTag();
        for (BlockState state : this.slices) {
            slice.add((Object)NbtUtils.writeBlockState((BlockState)state));
        }
        tag.put("slises", (Tag)slice);
    }

    @Override
    protected void fromNbt(CompoundTag tag) {
        super.fromNbt(tag);
        HolderLookup.RegistryLookup blockLookup = BuiltInRegistries.BLOCK.asLookup();
        ListTag slise = tag.getList("slises", 10);
        this.slices = new BlockState[slise.size()];
        for (int i = 0; i < this.slices.length; ++i) {
            this.slices[i] = NbtUtils.readBlockState((HolderGetter)blockLookup, (CompoundTag)slise.getCompound(i));
        }
    }

    public void postProcess(WorldGenLevel world, StructureManager arg, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox blockBox, ChunkPos chunkPos, BlockPos blockPos) {
        int sx = chunkPos.getMinBlockX();
        int sz = chunkPos.getMinBlockZ();
        BlockPos.MutableBlockPos pos = GlobalState.stateForThread().POS;
        ChunkAccess chunk = world.getChunk(chunkPos.x, chunkPos.z);
        Heightmap map = chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.WORLD_SURFACE);
        Heightmap map2 = chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.WORLD_SURFACE_WG);
        for (int x = 0; x < 16; ++x) {
            int px = x + sx;
            int px2 = px - this.center.getX();
            px2 *= px2;
            pos.setX(x);
            for (int z = 0; z < 16; ++z) {
                float maxY;
                float dist;
                int pz = z + sz;
                int pz2 = pz - this.center.getZ();
                if (!((dist = (float)(px2 + (pz2 *= pz2))) < this.r2)) continue;
                pos.setZ(z);
                dist = 1.0f - dist / this.r2;
                int minY = map.getFirstAvailable(x, z);
                pos.setY(minY - 1);
                while (chunk.getBlockState((BlockPos)pos).isAir() && pos.getY() > 50) {
                    pos.setY(minY--);
                }
                minY = pos.getY();
                if ((minY = Math.max(minY, map2.getFirstAvailable(x, z))) <= this.center.getY() - 8 || !((maxY = dist * this.height * this.getHeightClamp(world, 10, px, pz)) > 0.0f)) continue;
                maxY *= (float)this.noise1.eval((double)px * 0.05, (double)pz * 0.05) * 0.3f + 0.7f;
                maxY *= (float)this.noise1.eval((double)px * 0.1, (double)pz * 0.1) * 0.1f + 0.9f;
                maxY += (float)this.center.getY();
                float offset = (float)(this.noise1.eval((double)px * 0.07, (double)pz * 0.07) * 5.0 + this.noise1.eval((double)px * 0.2, (double)pz * 0.2) * 2.0 + 7.0);
                int y = minY - 1;
                while ((float)y < maxY) {
                    pos.setY(y);
                    int index = MHelper.floor((double)(((float)y + offset) * 0.65f)) % this.slices.length;
                    chunk.setBlockState((BlockPos)pos, this.slices[index], false);
                    ++y;
                }
            }
        }
    }
}

