/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.structures.piece;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.betterx.bclib.util.MHelper;
import org.betterx.bclib.util.StructureErode;
import org.betterx.bclib.util.StructureHelper;
import org.betterx.betterend.registry.EndStructures;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.structures.piece.BasePiece;

public class NBTPiece
extends BasePiece {
    private ResourceLocation structureID;
    private Rotation rotation;
    private Mirror mirror;
    private StructureTemplate structure;
    private BlockPos pos;
    private int erosion;
    private boolean cover;

    public NBTPiece(ResourceLocation structureID, StructureTemplate structure, BlockPos pos, int erosion, boolean cover, RandomSource random) {
        super(EndStructures.NBT_PIECE, random.nextInt(), null);
        this.structureID = structureID;
        this.structure = structure;
        this.rotation = Rotation.getRandom((RandomSource)random);
        this.mirror = Mirror.values()[random.nextInt(3)];
        this.pos = StructureHelper.offsetPos((BlockPos)pos, (StructureTemplate)structure, (Rotation)this.rotation, (Mirror)this.mirror);
        this.erosion = erosion;
        this.cover = cover;
        this.makeBoundingBox();
    }

    public NBTPiece(StructurePieceSerializationContext type, CompoundTag tag) {
        super(EndStructures.NBT_PIECE, tag);
        this.makeBoundingBox();
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putString("structureID", this.structureID.toString());
        tag.putInt("rotation", this.rotation.ordinal());
        tag.putInt("mirror", this.mirror.ordinal());
        tag.putInt("erosion", this.erosion);
        tag.put("pos", NbtUtils.writeBlockPos((BlockPos)this.pos));
        tag.putBoolean("cover", this.cover);
    }

    @Override
    protected void fromNbt(CompoundTag tag) {
        this.structureID = ResourceLocation.parse((String)tag.getString("structureID"));
        this.rotation = Rotation.values()[tag.getInt("rotation")];
        this.mirror = Mirror.values()[tag.getInt("mirror")];
        this.erosion = tag.getInt("erosion");
        this.pos = NbtUtils.readBlockPos((CompoundTag)tag, (String)"pos").orElse(BlockPos.ZERO);
        this.cover = tag.getBoolean("cover");
        this.structure = StructureHelper.readStructure((ResourceLocation)this.structureID);
    }

    public void postProcess(WorldGenLevel world, StructureManager arg, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox blockBox, ChunkPos chunkPos, BlockPos blockPos) {
        BoundingBox bounds = BoundingBox.fromCorners((Vec3i)new Vec3i(blockBox.minX(), this.boundingBox.minY(), blockBox.minZ()), (Vec3i)new Vec3i(blockBox.maxX(), this.boundingBox.maxX(), blockBox.maxZ()));
        StructurePlaceSettings placementData = new StructurePlaceSettings().setRotation(this.rotation).setMirror(this.mirror).setBoundingBox(bounds);
        this.structure.placeInWorld((ServerLevelAccessor)world, this.pos, this.pos, placementData, random, 2);
        if (this.erosion > 0) {
            int x1 = MHelper.min((int)bounds.maxX(), (int)this.boundingBox.maxX());
            int x0 = MHelper.max((int)bounds.minX(), (int)this.boundingBox.minX());
            int z1 = MHelper.min((int)bounds.maxZ(), (int)this.boundingBox.maxZ());
            int z0 = MHelper.max((int)bounds.minZ(), (int)this.boundingBox.minZ());
            bounds = BoundingBox.fromCorners((Vec3i)new Vec3i(x0, bounds.minY(), z0), (Vec3i)new Vec3i(x1, bounds.maxY(), z1));
            StructureErode.erode((WorldGenLevel)world, (BoundingBox)bounds, (int)this.erosion, (RandomSource)random);
        }
        if (this.cover) {
            StructureErode.cover((WorldGenLevel)world, (BoundingBox)bounds, (RandomSource)random, (BlockState)EndBiome.Config.DEFAULT_MATERIAL.getTopMaterial());
        }
    }

    private void makeBoundingBox() {
        this.boundingBox = StructureHelper.getStructureBounds((BlockPos)this.pos, (StructureTemplate)this.structure, (Rotation)this.rotation, (Mirror)this.mirror);
    }
}

