/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.structures.piece;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndStructures;
import org.betterx.betterend.util.GlobalState;
import org.betterx.betterend.world.structures.piece.MountainPiece;
import org.betterx.betterend.world.surface.SplitNoiseCondition;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class CrystalMountainPiece
extends MountainPiece {
    private BlockState top = EndBlocks.CRYSTAL_MOSS.defaultBlockState();

    public CrystalMountainPiece(BlockPos center, float radius, float height, RandomSource random, Holder<Biome> biome) {
        super(EndStructures.MOUNTAIN_PIECE, center, radius, height, random, biome);
    }

    public CrystalMountainPiece(StructurePieceSerializationContext type, CompoundTag tag) {
        super(EndStructures.MOUNTAIN_PIECE, tag);
    }

    @Override
    protected void fromNbt(CompoundTag tag) {
        super.fromNbt(tag);
    }

    public void postProcess(WorldGenLevel world, StructureManager arg, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox blockBox, ChunkPos chunkPos, BlockPos blockPos) {
        int height;
        int y;
        int z;
        int x;
        float fill;
        int radius;
        int i;
        BlockPos.MutableBlockPos pos = GlobalState.stateForThread().POS;
        ChunkAccess chunk = world.getChunk(chunkPos.x, chunkPos.z);
        Heightmap map = chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.WORLD_SURFACE);
        this.placeMountain(world, chunkPos, chunk, pos);
        int count = (map.getFirstAvailable(8, 8) - (this.center.getY() + 24)) / 7;
        count = Mth.clamp((int)count, (int)0, (int)8);
        for (i = 0; i < count; ++i) {
            radius = MHelper.randRange((int)2, (int)3, (RandomSource)random);
            fill = MHelper.randRange((float)0.0f, (float)1.0f, (RandomSource)random);
            x = MHelper.randRange((int)radius, (int)(15 - radius), (RandomSource)random);
            y = map.getFirstAvailable(x, z = MHelper.randRange((int)radius, (int)(15 - radius), (RandomSource)random));
            if (y <= 60) continue;
            pos.set(x, y, z);
            if (!chunk.getBlockState(pos.below()).is(Blocks.END_STONE)) continue;
            height = MHelper.floor((double)((float)radius * MHelper.randRange((float)1.5f, (float)3.0f, (RandomSource)random) + (float)(y - 80) * 0.3f));
            this.crystal(chunk, (BlockPos)pos, radius, height, fill, random);
        }
        count = (map.getFirstAvailable(8, 8) - (this.center.getY() + 24)) / 2;
        count = Mth.clamp((int)count, (int)4, (int)8);
        for (i = 0; i < count; ++i) {
            radius = MHelper.randRange((int)1, (int)2, (RandomSource)random);
            fill = random.nextBoolean() ? 0.0f : 1.0f;
            x = MHelper.randRange((int)radius, (int)(15 - radius), (RandomSource)random);
            y = map.getFirstAvailable(x, z = MHelper.randRange((int)radius, (int)(15 - radius), (RandomSource)random));
            if (y <= 20) continue;
            pos.set(x, y, z);
            if (chunk.getBlockState(pos.below()).getBlock() != Blocks.END_STONE) continue;
            height = MHelper.floor((double)((float)radius * MHelper.randRange((float)1.5f, (float)3.0f, (RandomSource)random) + (float)(y - 80) * 0.3f));
            this.crystal(chunk, (BlockPos)pos, radius, height, fill, random);
        }
    }

    private void placeMountain(WorldGenLevel world, ChunkPos chunkPos, ChunkAccess chunk, BlockPos.MutableBlockPos pos) {
        Heightmap map = chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.WORLD_SURFACE);
        int sx = chunkPos.getMinBlockX();
        int sz = chunkPos.getMinBlockZ();
        Heightmap map2 = chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.WORLD_SURFACE_WG);
        for (int x = 0; x < 16; ++x) {
            int px = x + sx;
            int px2 = px - this.center.getX();
            px2 *= px2;
            pos.setX(x);
            for (int z = 0; z < 16; ++z) {
                float maxY;
                float dist;
                int pz = z + sz;
                int pz2 = pz - this.center.getZ();
                if (!((dist = (float)(px2 + (pz2 *= pz2))) < this.r2)) continue;
                pos.setZ(z);
                dist = 1.0f - (float)Math.pow(dist / this.r2, 0.3);
                int minY = map.getFirstAvailable(x, z);
                if (minY < 10) continue;
                pos.setY(minY);
                while (!chunk.getBlockState((BlockPos)pos).is(CommonBlockTags.END_STONES) && pos.getY() > 56 && chunk.getBlockState(pos.below()).is(Blocks.CAVE_AIR)) {
                    pos.setY(pos.getY() - 1);
                }
                minY = pos.getY();
                if ((minY = Math.max(minY, map2.getFirstAvailable(x, z))) <= this.center.getY() - 8 || !((maxY = dist * this.height * this.getHeightClamp(world, 12, px, pz)) > 0.0f)) continue;
                maxY *= (float)this.noise1.eval((double)px * 0.05, (double)pz * 0.05) * 0.3f + 0.7f;
                maxY *= (float)this.noise1.eval((double)px * 0.1, (double)pz * 0.1) * 0.1f + 0.8f;
                int maxYI = (int)(maxY += (float)this.center.getY());
                int cover = maxYI - 1;
                double noise = SplitNoiseCondition.DEFAULT.getNoise(px, pz);
                boolean needCover = noise > -0.2;
                for (int y = minY - 1; y < maxYI; ++y) {
                    pos.setY(y);
                    if (needCover && y == cover) {
                        chunk.setBlockState((BlockPos)pos, this.top, false);
                        continue;
                    }
                    chunk.setBlockState((BlockPos)pos, Blocks.END_STONE.defaultBlockState(), false);
                }
            }
        }
    }

    private void crystal(ChunkAccess chunk, BlockPos pos, int radius, int height, float fill, RandomSource random) {
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        int max = MHelper.floor((double)(fill * (float)radius + (float)radius + 0.5f));
        height += pos.getY();
        Heightmap map = chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.WORLD_SURFACE);
        int coefX = MHelper.randRange((int)-1, (int)1, (RandomSource)random);
        int coefZ = MHelper.randRange((int)-1, (int)1, (RandomSource)random);
        for (int x = -radius; x <= radius; ++x) {
            mut.setX(x + pos.getX());
            if (mut.getX() < 0 || mut.getX() >= 16) continue;
            int ax = Math.abs(x);
            for (int z = -radius; z <= radius; ++z) {
                int az;
                mut.setZ(z + pos.getZ());
                if (mut.getZ() < 0 || mut.getZ() >= 16 || ax + (az = Math.abs(z)) >= max) continue;
                int minY = map.getFirstAvailable(mut.getX(), mut.getZ()) - MHelper.randRange((int)3, (int)7, (RandomSource)random);
                if (pos.getY() - minY > 8) {
                    minY = pos.getY() - 8;
                }
                int h = coefX * x + coefZ * z + height;
                for (int y = minY; y < h; ++y) {
                    mut.setY(y);
                    chunk.setBlockState((BlockPos)mut, EndBlocks.AURORA_CRYSTAL.defaultBlockState(), false);
                }
            }
        }
    }
}

