/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.structures.features;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.registry.EndStructures;
import org.betterx.betterend.world.structures.features.FeatureBaseStructure;
import org.betterx.betterend.world.structures.piece.LakePiece;

public class MegaLakeStructure
extends FeatureBaseStructure {
    public MegaLakeStructure(Structure.StructureSettings structureSettings) {
        super(structureSettings);
    }

    public StructureType<MegaLakeStructure> type() {
        return EndStructures.MEGALAKE.type();
    }

    @Override
    protected void generatePieces(StructurePiecesBuilder structurePiecesBuilder, Structure.GenerationContext context) {
        int z;
        WorldgenRandom random = context.random();
        ChunkPos chunkPos = context.chunkPos();
        ChunkGenerator chunkGenerator = context.chunkGenerator();
        RandomState rState = context.randomState();
        LevelHeightAccessor levelHeightAccessor = context.heightAccessor();
        int x = chunkPos.getBlockX(MHelper.randRange((int)4, (int)12, (RandomSource)random));
        int y = chunkGenerator.getBaseHeight(x, z = chunkPos.getBlockZ(MHelper.randRange((int)4, (int)12, (RandomSource)random)), Heightmap.Types.WORLD_SURFACE_WG, levelHeightAccessor, rState);
        if (y > 5) {
            Holder<Biome> biome = this.getNoiseBiome(chunkGenerator, rState, x >> 2, y >> 2, z >> 2);
            float radius = MHelper.randRange((int)32, (int)64, (RandomSource)random);
            float depth = MHelper.randRange((int)7, (int)15, (RandomSource)random);
            LakePiece piece = new LakePiece(new BlockPos(x, y, z), radius, depth, (RandomSource)random, biome);
            structurePiecesBuilder.addPiece((StructurePiece)piece);
        }
    }
}

