/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.structures.features;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.betterx.bclib.api.v2.levelgen.structures.StructurePlacementType;
import org.betterx.bclib.api.v2.levelgen.structures.TemplateStructure;
import org.betterx.bclib.util.StructureHelper;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.registry.EndStructures;
import org.betterx.betterend.world.structures.piece.NBTPiece;
import org.betterx.wover.structure.api.StructureUtils;

public class EternalPortalStructure
extends TemplateStructure {
    private static final ResourceLocation STRUCTURE_ID = BetterEnd.C.mk("portal/eternal_portal");
    private static final StructureTemplate STRUCTURE = StructureHelper.readStructure((ResourceLocation)STRUCTURE_ID);

    public EternalPortalStructure(Structure.StructureSettings s) {
        super(s, List.of(EternalPortalStructure.cfg("portal/eternal_portal", -2, StructurePlacementType.FLOOR, 1.0f)));
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        if (!StructureUtils.isValidBiome((Structure.GenerationContext)context)) {
            return Optional.empty();
        }
        ChunkPos chunkPos = context.chunkPos();
        ChunkGenerator chunkGenerator = context.chunkGenerator();
        LevelHeightAccessor levelHeightAccessor = context.heightAccessor();
        long x = (long)chunkPos.x * (long)chunkPos.x;
        long z = (long)chunkPos.z * (long)chunkPos.z;
        if (x + z < 1024L) {
            return Optional.empty();
        }
        if (chunkGenerator.getBaseHeight(chunkPos.getBlockX(8), chunkPos.getBlockZ(8), Heightmap.Types.WORLD_SURFACE_WG, levelHeightAccessor, context.randomState()) < 5) {
            return Optional.empty();
        }
        return super.findGenerationPoint(context);
    }

    public StructureType<EternalPortalStructure> type() {
        return EndStructures.ETERNAL_PORTAL.type();
    }

    protected int erosion(RandomSource rnd) {
        return rnd.nextInt(5);
    }

    protected boolean cover(RandomSource rnd) {
        return true;
    }

    protected void generatePieces(StructurePiecesBuilder structurePiecesBuilder, Structure.GenerationContext context) {
        WorldgenRandom random = context.random();
        ChunkPos chunkPos = context.chunkPos();
        ChunkGenerator chunkGenerator = context.chunkGenerator();
        LevelHeightAccessor levelHeightAccessor = context.heightAccessor();
        int x = chunkPos.getBlockX(8);
        int z = chunkPos.getBlockZ(8);
        int y = chunkGenerator.getBaseHeight(x, z, Heightmap.Types.WORLD_SURFACE_WG, levelHeightAccessor, context.randomState());
        structurePiecesBuilder.addPiece((StructurePiece)new NBTPiece(STRUCTURE_ID, STRUCTURE, new BlockPos(x, y - 4, z), random.nextInt(5), true, (RandomSource)random));
    }

    public static TemplateStructure.Config cfg(String name, int offsetY, StructurePlacementType type, float chance) {
        return new TemplateStructure.Config(BetterEnd.C.mk(name), offsetY, type, chance);
    }
}

