/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.trees;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFFlatWave;
import org.betterx.bclib.sdf.operator.SDFScale;
import org.betterx.bclib.sdf.operator.SDFScale3D;
import org.betterx.bclib.sdf.operator.SDFSmoothUnion;
import org.betterx.bclib.sdf.operator.SDFSubtraction;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.operator.SDFUnary;
import org.betterx.bclib.sdf.operator.SDFUnion;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.sdf.primitive.SDFSphere;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.bclib.util.SplineHelper;
import org.betterx.betterend.blocks.UmbrellaTreeClusterBlock;
import org.betterx.betterend.blocks.UmbrellaTreeMembraneBlock;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;
import org.joml.Vector3f;

public class UmbrellaTreeFeature
extends DefaultFeature {
    private static final Function<BlockState, Boolean> REPLACE;
    private static final List<Vector3f> SPLINE;
    private static final List<Vector3f> ROOT;

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        RandomSource random = featureConfig.random();
        BlockPos pos = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featureConfig.config();
        if (!world.getBlockState(pos.below()).is(BlockTags.NYLIUM)) {
            return false;
        }
        BlockState wood = EndBlocks.UMBRELLA_TREE.getBark().defaultBlockState();
        BlockState membrane = (BlockState)EndBlocks.UMBRELLA_TREE_MEMBRANE.defaultBlockState().setValue((Property)UmbrellaTreeMembraneBlock.COLOR, (Comparable)Integer.valueOf(1));
        BlockState center = (BlockState)EndBlocks.UMBRELLA_TREE_MEMBRANE.defaultBlockState().setValue((Property)UmbrellaTreeMembraneBlock.COLOR, (Comparable)Integer.valueOf(0));
        BlockState fruit = (BlockState)EndBlocks.UMBRELLA_TREE_CLUSTER.defaultBlockState().setValue((Property)UmbrellaTreeClusterBlock.NATURAL, (Comparable)Boolean.valueOf(true));
        float size = MHelper.randRange((int)10, (int)20, (RandomSource)random);
        int count = (int)(size * 0.15f);
        float var = (float)Math.PI * 2 / (float)(count * 3);
        float start = MHelper.randRange((float)0.0f, (float)((float)Math.PI * 2), (RandomSource)random);
        SDFUnary sdf = null;
        ArrayList centers = Lists.newArrayList();
        float scale = 1.0f;
        if (config != null) {
            scale = MHelper.randRange((float)1.0f, (float)1.7f, (RandomSource)random);
        }
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2) + MHelper.randRange((float)0.0f, (float)var, (RandomSource)random) + start;
            List spline = SplineHelper.copySpline(SPLINE);
            float sizeXZ = (size + MHelper.randRange((float)0.0f, (float)(size * 0.5f), (RandomSource)random)) * 0.7f;
            SplineHelper.scale((List)spline, (float)sizeXZ, (float)(sizeXZ * MHelper.randRange((float)1.0f, (float)2.0f, (RandomSource)random)), (float)sizeXZ);
            SplineHelper.rotateSpline((List)spline, (float)angle);
            SplineHelper.offsetParts((List)spline, (RandomSource)random, (float)0.5f, (float)0.0f, (float)0.5f);
            if (!SplineHelper.canGenerate((List)spline, (BlockPos)pos, (WorldGenLevel)world, REPLACE)) continue;
            float rScale = (scale - 1.0f) * 0.4f + 1.0f;
            SDF branch = SplineHelper.buildSDF((List)spline, (float)(1.2f * rScale), (float)(0.8f * rScale), bpos -> wood);
            Vector3f vec = (Vector3f)spline.get(spline.size() - 1);
            float radius = (size + MHelper.randRange((float)0.0f, (float)(size * 0.5f), (RandomSource)random)) * 0.4f;
            sdf = sdf == null ? branch : new SDFUnion().setSourceA((SDF)sdf).setSourceB(branch);
            SDF mem = this.makeMembrane(radius, random, membrane, center);
            float px = (float)MHelper.floor((double)vec.x()) + 0.5f;
            float py = (float)MHelper.floor((double)vec.y()) + 0.5f;
            float pz = (float)MHelper.floor((double)vec.z()) + 0.5f;
            mem = new SDFTranslate().setTranslate(px, py, pz).setSource(mem);
            sdf = new SDFSmoothUnion().setRadius(2.0f).setSourceA((SDF)sdf).setSourceB(mem);
            centers.add(new Center((double)pos.getX() + (double)(px * scale), (double)pos.getY() + (double)(py * scale), (double)pos.getZ() + (double)(pz * scale), radius * scale));
        }
        if (sdf == null) {
            return false;
        }
        if (scale > 1.0f) {
            sdf = new SDFScale().setScale(scale).setSource(sdf);
        }
        sdf.setReplaceFunction(REPLACE).addPostProcess(info -> {
            if (EndBlocks.UMBRELLA_TREE.isTreeLog(info.getStateUp()) && EndBlocks.UMBRELLA_TREE.isTreeLog(info.getStateDown())) {
                return EndBlocks.UMBRELLA_TREE.getLog().defaultBlockState();
            }
            if (info.getState().equals(membrane)) {
                Center min = (Center)centers.get(0);
                double d = Double.MAX_VALUE;
                BlockPos bpos = info.getPos();
                for (Center c : centers) {
                    double d2 = c.distance(bpos.getX(), bpos.getZ());
                    if (!(d2 < d)) continue;
                    d = d2;
                    min = c;
                }
                int color = MHelper.floor((double)(d / (double)min.radius * 7.0));
                color = Mth.clamp((int)color, (int)1, (int)7);
                return (BlockState)info.getState().setValue((Property)UmbrellaTreeMembraneBlock.COLOR, (Comparable)Integer.valueOf(color));
            }
            return info.getState();
        }).fillRecursive((ServerLevelAccessor)world, pos);
        this.makeRoots(world, pos, (size * 0.5f + 3.0f) * scale, random, wood);
        for (Center c : centers) {
            if (world.getBlockState(new BlockPos((int)c.px, (int)c.py, (int)c.pz)).isAir()) continue;
            count = MHelper.floor((double)(MHelper.randRange((float)5.0f, (float)10.0f, (RandomSource)random) * scale));
            float startAngle = random.nextFloat() * ((float)Math.PI * 2);
            for (int i = 0; i < count; ++i) {
                float angle = (float)i / (float)count * ((float)Math.PI * 2) + startAngle;
                float dist = MHelper.randRange((float)1.5f, (float)2.5f, (RandomSource)random) * scale;
                double px = c.px + Math.sin(angle) * (double)dist;
                double pz = c.pz + Math.cos(angle) * (double)dist;
                this.makeFruits(world, px, c.py - 1.0, pz, fruit);
            }
        }
        return true;
    }

    private void makeRoots(WorldGenLevel world, BlockPos pos, float radius, RandomSource random, BlockState wood) {
        int count = (int)(radius * 1.5f);
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2);
            float scale = radius * MHelper.randRange((float)0.85f, (float)1.15f, (RandomSource)random);
            List branch = SplineHelper.copySpline(ROOT);
            SplineHelper.rotateSpline((List)branch, (float)angle);
            SplineHelper.scale((List)branch, (float)scale);
            Vector3f last = (Vector3f)branch.get(branch.size() - 1);
            if (!world.getBlockState(pos.offset((int)last.x(), (int)last.y(), (int)last.z())).is(CommonBlockTags.END_STONES)) continue;
            SplineHelper.fillSplineForce((List)branch, (WorldGenLevel)world, (BlockState)wood, (BlockPos)pos, REPLACE);
        }
    }

    private SDF makeMembrane(float radius, RandomSource random, BlockState membrane, BlockState center) {
        SDFPrimitive sphere = new SDFSphere().setRadius(radius).setBlock(membrane);
        SDFUnary sub = new SDFTranslate().setTranslate(0.0f, -4.0f, 0.0f).setSource((SDF)sphere);
        sphere = new SDFSubtraction().setSourceA((SDF)sphere).setSourceB((SDF)sub);
        sphere = new SDFScale3D().setScale(1.0f, 0.5f, 1.0f).setSource((SDF)sphere);
        sphere = new SDFTranslate().setTranslate(0.0f, 1.0f - radius * 0.5f, 0.0f).setSource((SDF)sphere);
        float angle = random.nextFloat() * ((float)Math.PI * 2);
        int count = (int)MHelper.randRange((float)radius, (float)(radius * 2.0f), (RandomSource)random);
        if (count < 5) {
            count = 5;
        }
        sphere = new SDFFlatWave().setAngle(angle).setRaysCount(count).setIntensity(0.6f).setSource((SDF)sphere);
        SDFPrimitive cent = new SDFSphere().setRadius(2.5f).setBlock(center);
        sphere = new SDFUnion().setSourceA((SDF)sphere).setSourceB((SDF)cent);
        return sphere;
    }

    private void makeFruits(WorldGenLevel world, double px, double py, double pz, BlockState fruit) {
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos().set(px, py, pz);
        for (int i = 0; i < 8; ++i) {
            mut.move(Direction.DOWN);
            if (!world.isEmptyBlock((BlockPos)mut)) continue;
            BlockState state = world.getBlockState(mut.above());
            if (!state.is(EndBlocks.UMBRELLA_TREE_MEMBRANE) || (Integer)state.getValue((Property)UmbrellaTreeMembraneBlock.COLOR) >= 2) break;
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)fruit);
            break;
        }
    }

    static {
        SPLINE = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.1f, 0.35f, 0.0f), new Vector3f(0.2f, 0.5f, 0.0f), new Vector3f(0.3f, 0.55f, 0.0f), new Vector3f(0.42f, 0.7f, 0.0f), new Vector3f(0.5f, 1.0f, 0.0f)});
        ROOT = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.1f, 0.7f, 0.0f), new Vector3f(0.3f, 0.3f, 0.0f), new Vector3f(0.7f, 0.05f, 0.0f), new Vector3f(0.8f, -0.2f, 0.0f)});
        SplineHelper.offset(ROOT, (Vector3f)new Vector3f(0.0f, -0.45f, 0.0f));
        REPLACE = state -> {
            if (state.is(EndBlocks.UMBRELLA_TREE_MEMBRANE)) {
                return true;
            }
            return BlocksHelper.replaceableOrPlant((BlockState)state);
        };
    }

    private static class Center {
        final double px;
        final double py;
        final double pz;
        final float radius;

        Center(double x, double y, double z, float radius) {
            this.px = x;
            this.py = y;
            this.pz = z;
            this.radius = radius;
        }

        double distance(float x, float z) {
            return MHelper.length((double)(this.px - (double)x), (double)(this.pz - (double)z));
        }
    }
}

