/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.trees;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFDisplacement;
import org.betterx.bclib.sdf.operator.SDFScale;
import org.betterx.bclib.sdf.operator.SDFScale3D;
import org.betterx.bclib.sdf.operator.SDFSubtraction;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.operator.SDFUnary;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.sdf.primitive.SDFSphere;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.bclib.util.SplineHelper;
import org.betterx.betterend.blocks.basis.FurBlock;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.wover.block.api.BlockProperties;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;
import org.joml.Vector3f;

public class LucerniaFeature
extends DefaultFeature {
    private static final Direction[] DIRECTIONS = Direction.values();
    private static final Function<BlockState, Boolean> REPLACE = state -> {
        if (state.getBlock() == EndBlocks.LUCERNIA_LEAVES) {
            return true;
        }
        return BlocksHelper.replaceableOrPlant((BlockState)state);
    };
    private static final Function<BlockState, Boolean> IGNORE = EndBlocks.LUCERNIA::isTreeLog;
    private static final List<Vector3f> SPLINE = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.1f, 0.35f, 0.0f), new Vector3f(0.2f, 0.5f, 0.0f), new Vector3f(0.3f, 0.55f, 0.0f), new Vector3f(0.42f, 0.7f, 0.0f), new Vector3f(0.5f, 1.0f, 0.0f)});
    private static final List<Vector3f> ROOT = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.1f, 0.7f, 0.0f), new Vector3f(0.3f, 0.3f, 0.0f), new Vector3f(0.7f, 0.05f, 0.0f), new Vector3f(0.8f, -0.2f, 0.0f)});

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        RandomSource random = featureConfig.random();
        BlockPos pos = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featureConfig.config();
        if (!world.getBlockState(pos.below()).is(BlockTags.NYLIUM)) {
            return false;
        }
        float size = MHelper.randRange((int)12, (int)20, (RandomSource)random);
        int count = (int)(size * 0.3f);
        float var = (float)Math.PI * 2 / (float)(count * 3);
        float start = MHelper.randRange((float)0.0f, (float)((float)Math.PI * 2), (RandomSource)random);
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2) + MHelper.randRange((float)0.0f, (float)var, (RandomSource)random) + start;
            List spline = SplineHelper.copySpline(SPLINE);
            SplineHelper.rotateSpline((List)spline, (float)angle);
            SplineHelper.scale((List)spline, (float)(size * MHelper.randRange((float)0.5f, (float)1.0f, (RandomSource)random)));
            SplineHelper.offsetParts((List)spline, (RandomSource)random, (float)1.0f, (float)0.0f, (float)1.0f);
            SplineHelper.fillSpline((List)spline, (WorldGenLevel)world, (BlockState)EndBlocks.LUCERNIA.getBark().defaultBlockState(), (BlockPos)pos, REPLACE);
            Vector3f last = (Vector3f)spline.get(spline.size() - 1);
            float leavesRadius = (size * 0.13f + MHelper.randRange((float)0.8f, (float)1.5f, (RandomSource)random)) * 1.4f;
            OpenSimplexNoise noise = new OpenSimplexNoise(random.nextLong());
            this.leavesBall(world, pos.offset((int)last.x(), (int)last.y(), (int)last.z()), leavesRadius, random, noise, config != null);
        }
        this.makeRoots(world, pos.offset(0, MHelper.randRange((int)3, (int)5, (RandomSource)random), 0), size * 0.35f, random);
        return true;
    }

    private void leavesBall(WorldGenLevel world, BlockPos pos, float radius, RandomSource random, OpenSimplexNoise noise, boolean natural) {
        SDFPrimitive sphere = new SDFSphere().setRadius(radius).setBlock((BlockState)EndBlocks.LUCERNIA_LEAVES.defaultBlockState().setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(6)));
        SDFUnary sub = new SDFScale().setScale(5.0f).setSource((SDF)sphere);
        sub = new SDFTranslate().setTranslate(0.0f, -radius * 5.0f, 0.0f).setSource((SDF)sub);
        sphere = new SDFSubtraction().setSourceA((SDF)sphere).setSourceB((SDF)sub);
        sphere = new SDFScale3D().setScale(1.0f, 0.75f, 1.0f).setSource((SDF)sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval((double)vec.x() * 0.2, (double)vec.y() * 0.2, (double)vec.z() * 0.2) * 2.0f)).setSource((SDF)sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf(MHelper.randRange((float)-1.5f, (float)1.5f, (RandomSource)random))).setSource((SDF)sphere);
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        for (Direction d1 : BlocksHelper.HORIZONTAL) {
            BlockPos p = mut.set((Vec3i)pos).move(Direction.UP).move(d1).immutable();
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)p, (BlockState)EndBlocks.LUCERNIA.getBark().defaultBlockState());
            for (Direction d2 : BlocksHelper.HORIZONTAL) {
                mut.set((Vec3i)p).move(Direction.UP).move(d2);
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)p, (BlockState)EndBlocks.LUCERNIA.getBark().defaultBlockState());
            }
        }
        BlockState top = (BlockState)EndBlocks.FILALUX.defaultBlockState().setValue((Property)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.TOP);
        BlockState middle = (BlockState)EndBlocks.FILALUX.defaultBlockState().setValue((Property)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE);
        BlockState bottom = (BlockState)EndBlocks.FILALUX.defaultBlockState().setValue((Property)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM);
        BlockState outer = EndBlocks.LUCERNIA_OUTER_LEAVES.defaultBlockState();
        ArrayList support = Lists.newArrayList();
        sphere.addPostProcess(info -> {
            if (natural && random.nextInt(6) == 0 && info.getStateDown().isAir()) {
                BlockPos d = info.getPos().below();
                support.add(d);
            }
            if (random.nextInt(15) == 0) {
                for (BlockPos blockPos : Direction.values()) {
                    BlockState state = info.getState((Direction)blockPos, 2);
                    if (!state.isAir()) continue;
                    return info.getState();
                }
                info.setState(EndBlocks.LUCERNIA.getBark().defaultBlockState());
            }
            MHelper.shuffle((Object[])DIRECTIONS, (RandomSource)random);
            for (BlockPos blockPos : DIRECTIONS) {
                if (!info.getState((Direction)blockPos).isAir()) continue;
                info.setBlockPos(info.getPos().relative((Direction)blockPos), (BlockState)outer.setValue((Property)FurBlock.FACING, (Comparable)blockPos));
            }
            if (EndBlocks.LUCERNIA.isTreeLog(info.getState())) {
                for (int x = -6; x < 7; ++x) {
                    int ax = Math.abs(x);
                    mut.setX(x + info.getPos().getX());
                    for (int z = -6; z < 7; ++z) {
                        int n = Math.abs(z);
                        mut.setZ(z + info.getPos().getZ());
                        for (int y = -6; y < 7; ++y) {
                            int distance;
                            int ay = Math.abs(y);
                            int d = ax + ay + n;
                            if (d >= 7) continue;
                            mut.setY(y + info.getPos().getY());
                            BlockState state = info.getState((BlockPos)mut);
                            if (!(state.getBlock() instanceof LeavesBlock) || d >= (distance = ((Integer)state.getValue((Property)LeavesBlock.DISTANCE)).intValue())) continue;
                            info.setState((BlockPos)mut, (BlockState)state.setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(d)));
                        }
                    }
                }
            }
            return info.getState();
        });
        sphere.fillRecursiveIgnore((ServerLevelAccessor)world, pos, IGNORE);
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (Block)EndBlocks.LUCERNIA.getBark());
        support.forEach(bpos -> {
            BlockState state = world.getBlockState(bpos);
            if (state.isAir() || state.is(EndBlocks.LUCERNIA_OUTER_LEAVES)) {
                int count = MHelper.randRange((int)3, (int)8, (RandomSource)random);
                mut.set((Vec3i)bpos);
                if (world.getBlockState(mut.above()).is(EndBlocks.LUCERNIA_LEAVES)) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)top);
                    for (int i = 1; i < count; ++i) {
                        mut.setY(mut.getY() - 1);
                        if (!world.isEmptyBlock(mut.below())) break;
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)middle);
                    }
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)bottom);
                }
            }
        });
    }

    private void makeRoots(WorldGenLevel world, BlockPos pos, float radius, RandomSource random) {
        int count = (int)(radius * 1.5f);
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2);
            float scale = radius * MHelper.randRange((float)0.85f, (float)1.15f, (RandomSource)random);
            List branch = SplineHelper.copySpline(ROOT);
            SplineHelper.rotateSpline((List)branch, (float)angle);
            SplineHelper.scale((List)branch, (float)scale);
            Vector3f last = (Vector3f)branch.get(branch.size() - 1);
            if (!world.getBlockState(pos.offset((int)last.x(), (int)last.y(), (int)last.z())).is(CommonBlockTags.END_STONES)) continue;
            SplineHelper.fillSplineForce((List)branch, (WorldGenLevel)world, (BlockState)EndBlocks.LUCERNIA.getBark().defaultBlockState(), (BlockPos)pos, REPLACE);
        }
    }

    static {
        SplineHelper.offset(ROOT, (Vector3f)new Vector3f(0.0f, -0.45f, 0.0f));
    }
}

