/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain.caves;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.world.features.terrain.caves.EndCaveFeatures;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class RoundCaveFeature
extends EndCaveFeatures {
    @Override
    protected Set<BlockPos> generate(WorldGenLevel world, BlockPos center, int radius, RandomSource random) {
        OpenSimplexNoise noise = new OpenSimplexNoise(MHelper.getSeed((int)534, (int)center.getX(), (int)center.getZ()));
        int x1 = center.getX() - radius - 5;
        int z1 = center.getZ() - radius - 5;
        int x2 = center.getX() + radius + 5;
        int z2 = center.getZ() + radius + 5;
        int y1 = MHelper.floor((double)((double)center.getY() - (double)(radius + 5) / 1.6));
        int y2 = MHelper.floor((double)((double)center.getY() + (double)(radius + 5) / 1.6));
        double hr = (double)radius * 0.75;
        double nr = (double)radius * 0.25;
        int dx = x2 - x1 + 1;
        int dz = z2 - z1 + 1;
        int count = dx * dz;
        Set blocks = Sets.newConcurrentHashSet();
        IntStream.range(0, count).parallel().forEach(index -> {
            BlockPos.MutableBlockPos bpos = new BlockPos.MutableBlockPos();
            int x = index % dx + x1;
            int z = index / dx + z1;
            bpos.setX(x);
            bpos.setZ(z);
            int xsq = MHelper.sqr((int)(x - center.getX()));
            int zsq = MHelper.sqr((int)(z - center.getZ()));
            int dxz = xsq + zsq;
            for (int y = y1; y <= y2; ++y) {
                double r;
                int ysq = (int)MHelper.sqr((double)((double)(y - center.getY()) * 1.6));
                double dist = dxz + ysq;
                if (!(dist < (r = noise.eval((double)x * 0.1, (double)y * 0.1, (double)z * 0.1) * nr + hr) * r)) continue;
                bpos.setY(y);
                BlockState state = world.getBlockState((BlockPos)bpos);
                if (!this.isReplaceable(state) || this.isWaterNear(world, (BlockPos)bpos)) continue;
                blocks.add(bpos.immutable());
                while (state.is(BlockTags.LEAVES)) {
                    bpos.setY(bpos.getY() + 1);
                    state = world.getBlockState((BlockPos)bpos);
                }
                bpos.setY(y - 1);
                while (state.is(BlockTags.LEAVES)) {
                    bpos.setY(bpos.getY() - 1);
                    state = world.getBlockState((BlockPos)bpos);
                }
            }
        });
        blocks.forEach(bpos -> BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)CAVE_AIR));
        return blocks;
    }

    private boolean isReplaceable(BlockState state) {
        return state.is(CommonBlockTags.END_STONES) || BlocksHelper.replaceableOrPlant((BlockState)state) != false || state.is(BlockTags.LEAVES);
    }
}

