/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.blocks.HydrothermalVentBlock;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class SurfaceVentFeature
extends DefaultFeature {
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        RandomSource random = featureConfig.random();
        BlockPos pos = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        if (!world.getBlockState((pos = SurfaceVentFeature.getPosOnSurface((WorldGenLevel)world, (BlockPos)new BlockPos(pos.getX() + random.nextInt(16), pos.getY(), pos.getZ() + random.nextInt(16)))).below(3)).is(CommonBlockTags.END_STONES)) {
            return false;
        }
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        int count = MHelper.randRange((int)15, (int)30, (RandomSource)random);
        BlockState vent = (BlockState)EndBlocks.HYDROTHERMAL_VENT.defaultBlockState().setValue((Property)HydrothermalVentBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        for (int i = 0; i < count; ++i) {
            mut.set((Vec3i)pos).move(MHelper.floor((double)(random.nextGaussian() * 2.0 + 0.5)), 5, MHelper.floor((double)(random.nextGaussian() * 2.0 + 0.5)));
            int dist = MHelper.floor((double)(2.0f - MHelper.length((float)(mut.getX() - pos.getX()), (float)(mut.getZ() - pos.getZ())))) + random.nextInt(2);
            if (dist <= 0) continue;
            BlockState state = world.getBlockState((BlockPos)mut);
            for (int n = 0; n < 10 && state.isAir(); ++n) {
                mut.setY(mut.getY() - 1);
                state = world.getBlockState((BlockPos)mut);
            }
            if (!state.is(CommonBlockTags.END_STONES) || world.getBlockState(mut.above()).is(EndBlocks.HYDROTHERMAL_VENT)) continue;
            for (int j = 0; j <= dist; ++j) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.SULPHURIC_ROCK.stone);
                mut.setY(mut.getY() + 1);
            }
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)vent);
        }
        return true;
    }
}

