/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain;

import com.google.common.collect.Sets;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.blocks.SulphurCrystalBlock;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.util.GlobalState;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class SulphuricLakeFeature
extends DefaultFeature {
    private static final OpenSimplexNoise NOISE = new OpenSimplexNoise(15152L);

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        BlockPos blockPos = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        blockPos = SulphuricLakeFeature.getPosOnSurfaceWG((WorldGenLevel)world, (BlockPos)blockPos);
        if (blockPos.getY() < 57) {
            return false;
        }
        RandomSource random = featureConfig.random();
        BlockPos.MutableBlockPos POS = GlobalState.stateForThread().POS;
        double radius = MHelper.randRange((double)10.0, (double)20.0, (RandomSource)random);
        int dist2 = MHelper.floor((double)(radius * 1.5));
        int minX = blockPos.getX() - dist2;
        int maxX = blockPos.getX() + dist2;
        int minZ = blockPos.getZ() - dist2;
        int maxZ = blockPos.getZ() + dist2;
        HashSet brimstone = Sets.newHashSet();
        for (int x = minX; x <= maxX; ++x) {
            POS.setX(x);
            int x2 = x - blockPos.getX();
            x2 *= x2;
            for (int z = minZ; z <= maxZ; ++z) {
                POS.setZ(z);
                int z2 = z - blockPos.getZ();
                z2 *= z2;
                double r = radius * (NOISE.eval((double)x * 0.2, (double)z * 0.2) * 0.25 + 0.75);
                double r2 = r * 1.5;
                r *= r;
                r2 *= r2;
                int dist = x2 + z2;
                if ((double)dist <= r) {
                    BlockPos offseted;
                    POS.setY(SulphuricLakeFeature.getYOnSurface((WorldGenLevel)world, (int)x, (int)z) - 1);
                    if (!world.getBlockState((BlockPos)POS).is(CommonBlockTags.END_STONES)) continue;
                    if (this.isBorder(world, (BlockPos)POS)) {
                        if (random.nextInt(8) > 0) {
                            brimstone.add(POS.immutable());
                            if (!random.nextBoolean()) continue;
                            brimstone.add(POS.below());
                            if (!random.nextBoolean()) continue;
                            brimstone.add(POS.below(2));
                            continue;
                        }
                        if (!this.isAbsoluteBorder(world, (BlockPos)POS)) {
                            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)POS, (Block)Blocks.WATER);
                            world.scheduleTick((BlockPos)POS, (Fluid)Fluids.WATER, 0);
                            brimstone.add(POS.below());
                            if (!random.nextBoolean()) continue;
                            brimstone.add(POS.below(2));
                            if (!random.nextBoolean()) continue;
                            brimstone.add(POS.below(3));
                            continue;
                        }
                        brimstone.add(POS.immutable());
                        if (!random.nextBoolean()) continue;
                        brimstone.add(POS.below());
                        continue;
                    }
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)POS, (Block)Blocks.WATER);
                    brimstone.remove(POS);
                    for (Direction dir : BlocksHelper.HORIZONTAL) {
                        offseted = POS.relative(dir);
                        if (!world.getBlockState(offseted).is(CommonBlockTags.END_STONES)) continue;
                        brimstone.add(offseted);
                    }
                    if (this.isDeepWater(world, (BlockPos)POS)) {
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)POS.move(Direction.DOWN), (Block)Blocks.WATER);
                        brimstone.remove(POS);
                        for (Direction dir : BlocksHelper.HORIZONTAL) {
                            offseted = POS.relative(dir);
                            if (!world.getBlockState(offseted).is(CommonBlockTags.END_STONES)) continue;
                            brimstone.add(offseted);
                        }
                    }
                    brimstone.add(POS.below());
                    if (!random.nextBoolean()) continue;
                    brimstone.add(POS.below(2));
                    if (!random.nextBoolean()) continue;
                    brimstone.add(POS.below(3));
                    continue;
                }
                if (!((double)dist < r2)) continue;
                POS.setY(SulphuricLakeFeature.getYOnSurface((WorldGenLevel)world, (int)x, (int)z) - 1);
                if (!world.getBlockState((BlockPos)POS).is(CommonBlockTags.END_STONES)) continue;
                brimstone.add(POS.immutable());
                if (!random.nextBoolean()) continue;
                brimstone.add(POS.below());
                if (!random.nextBoolean()) continue;
                brimstone.add(POS.below(2));
            }
        }
        brimstone.forEach(bpos -> this.placeBrimstone(world, (BlockPos)bpos, random));
        return true;
    }

    private boolean isBorder(WorldGenLevel world, BlockPos pos) {
        int y = pos.getY() + 1;
        for (Direction dir : BlocksHelper.DIRECTIONS) {
            if (SulphuricLakeFeature.getYOnSurface((WorldGenLevel)world, (int)(pos.getX() + dir.getStepX()), (int)(pos.getZ() + dir.getStepZ())) >= y) continue;
            return true;
        }
        return false;
    }

    private boolean isAbsoluteBorder(WorldGenLevel world, BlockPos pos) {
        int y = pos.getY() - 2;
        for (Direction dir : BlocksHelper.DIRECTIONS) {
            if (SulphuricLakeFeature.getYOnSurface((WorldGenLevel)world, (int)(pos.getX() + dir.getStepX() * 3), (int)(pos.getZ() + dir.getStepZ() * 3)) >= y) continue;
            return true;
        }
        return false;
    }

    private boolean isDeepWater(WorldGenLevel world, BlockPos pos) {
        int y = pos.getY() + 1;
        for (Direction dir : BlocksHelper.DIRECTIONS) {
            if (SulphuricLakeFeature.getYOnSurface((WorldGenLevel)world, (int)(pos.getX() + dir.getStepX()), (int)(pos.getZ() + dir.getStepZ())) >= y && SulphuricLakeFeature.getYOnSurface((WorldGenLevel)world, (int)(pos.getX() + dir.getStepX() * 2), (int)(pos.getZ() + dir.getStepZ() * 2)) >= y && SulphuricLakeFeature.getYOnSurface((WorldGenLevel)world, (int)(pos.getX() + dir.getStepX() * 3), (int)(pos.getZ() + dir.getStepZ() * 3)) >= y) continue;
            return false;
        }
        return true;
    }

    private void placeBrimstone(WorldGenLevel world, BlockPos pos, RandomSource random) {
        BlockState state = this.getBrimstone(world, pos);
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)state);
        if (((Boolean)state.getValue((Property)EndBlockProperties.ACTIVE)).booleanValue()) {
            this.makeShards(world, pos, random);
        }
    }

    private BlockState getBrimstone(WorldGenLevel world, BlockPos pos) {
        for (Direction dir : BlocksHelper.DIRECTIONS) {
            if (!world.getBlockState(pos.relative(dir)).is(Blocks.WATER)) continue;
            return (BlockState)EndBlocks.BRIMSTONE.defaultBlockState().setValue((Property)EndBlockProperties.ACTIVE, (Comparable)Boolean.valueOf(true));
        }
        return EndBlocks.BRIMSTONE.defaultBlockState();
    }

    private void makeShards(WorldGenLevel world, BlockPos pos, RandomSource random) {
        for (Direction dir : BlocksHelper.DIRECTIONS) {
            BlockPos side;
            if (random.nextInt(16) != 0 || !world.getBlockState(side = pos.relative(dir)).is(Blocks.WATER)) continue;
            BlockState state = (BlockState)((BlockState)((BlockState)EndBlocks.SULPHUR_CRYSTAL.defaultBlockState().setValue((Property)SulphurCrystalBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true))).setValue((Property)SulphurCrystalBlock.FACING, (Comparable)dir)).setValue((Property)SulphurCrystalBlock.AGE, (Comparable)Integer.valueOf(random.nextInt(3)));
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)side, (BlockState)state);
        }
    }
}

