/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.wover.block.api.BlockProperties;

public class SulphurHillFeature
extends DefaultFeature {
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        RandomSource random = featureConfig.random();
        BlockPos pos = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        pos = SulphurHillFeature.getPosOnSurfaceWG((WorldGenLevel)world, (BlockPos)pos);
        if (pos.getY() < 57 || pos.getY() > 70) {
            return false;
        }
        int count = MHelper.randRange((int)5, (int)13, (RandomSource)random);
        OpenSimplexNoise noise = new OpenSimplexNoise(random.nextLong());
        for (int i = 0; i < count; ++i) {
            int pz;
            int dist = count - i;
            int px = pos.getX() + MHelper.floor((double)(random.nextGaussian() * (double)dist * 0.6 + 0.5));
            int py = SulphurHillFeature.getYOnSurface((WorldGenLevel)world, (int)px, (int)(pz = pos.getZ() + MHelper.floor((double)(random.nextGaussian() * (double)dist * 0.6 + 0.5))));
            if (py <= 56 || py - pos.getY() > count) continue;
            this.makeCircle(world, new BlockPos(px, py, pz), noise, random);
        }
        return true;
    }

    private void makeCircle(WorldGenLevel world, BlockPos pos, OpenSimplexNoise noise, RandomSource random) {
        int radius = MHelper.randRange((int)5, (int)9, (RandomSource)random);
        int min = -radius - 3;
        int max = radius + 4;
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        BlockState rock = EndBlocks.SULPHURIC_ROCK.stone.defaultBlockState();
        BlockState brimstone = (BlockState)EndBlocks.BRIMSTONE.defaultBlockState().setValue((Property)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(true));
        for (int x = min; x < max; ++x) {
            int x2 = x * x;
            int px = pos.getX() + x;
            mut.setX(px);
            for (int z = min; z < max; ++z) {
                int i;
                int maxIt;
                int z2 = z * z;
                int pz = pos.getZ() + z;
                mut.setZ(pz);
                double r1 = (double)radius * (noise.eval((double)px * 0.1, (double)pz * 0.1) * 0.2 + 0.8);
                double r2 = r1 - 1.5;
                double r3 = r1 - 3.0;
                int d = x2 + z2;
                mut.setY(pos.getY());
                BlockState state = world.getBlockState((BlockPos)mut);
                if (!state.canBeReplaced() && !state.is(EndBlocks.HYDROTHERMAL_VENT)) continue;
                if ((double)d < r2 * r2) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)Blocks.WATER);
                    mut.move(Direction.DOWN);
                    if ((double)d < r3 * r3) {
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)Blocks.WATER);
                        mut.move(Direction.DOWN);
                    }
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)brimstone);
                    mut.move(Direction.DOWN);
                    state = world.getBlockState((BlockPos)mut);
                    maxIt = MHelper.floor((double)(10.0 - Math.sqrt(d))) + random.nextInt(1);
                    for (i = 0; i < maxIt && state.canBeReplaced(); ++i) {
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)rock);
                        mut.move(Direction.DOWN);
                    }
                    continue;
                }
                if (!((double)d < r1 * r1)) continue;
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)brimstone);
                mut.move(Direction.DOWN);
                state = world.getBlockState((BlockPos)mut);
                maxIt = MHelper.floor((double)(10.0 - Math.sqrt(d))) + random.nextInt(1);
                for (i = 0; i < maxIt && state.canBeReplaced(); ++i) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)rock);
                    mut.move(Direction.DOWN);
                }
            }
        }
    }
}

