/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;

public class StalactiteFeatureConfig
implements FeatureConfiguration {
    public static final Codec<StalactiteFeatureConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("ceiling").forGetter(o -> o.ceiling), (App)BlockStateProvider.CODEC.fieldOf("states").forGetter(o -> o.block), (App)BlockPredicate.CODEC.fieldOf("allowed_ground").forGetter(o -> o.allowedGround)).apply((Applicative)instance, StalactiteFeatureConfig::new));
    public final boolean ceiling;
    public final BlockStateProvider block;
    public final BlockPredicate allowedGround;

    public StalactiteFeatureConfig(boolean ceiling, Block block, Block ... ground) {
        this(ceiling, (BlockStateProvider)SimpleStateProvider.simple((Block)block), BlockPredicate.matchesBlocks((Block[])ground));
    }

    public StalactiteFeatureConfig(boolean ceiling, Block block, int weight, Block block2, int weight2, Block ... ground) {
        this(ceiling, (BlockStateProvider)new WeightedStateProvider(new SimpleWeightedRandomList.Builder().add((Object)block.defaultBlockState(), weight).add((Object)block2.defaultBlockState(), weight2).build()), BlockPredicate.matchesBlocks((Block[])ground));
    }

    public StalactiteFeatureConfig(boolean ceiling, BlockStateProvider block, BlockPredicate allowedGround) {
        this.ceiling = ceiling;
        this.block = block;
        this.allowedGround = allowedGround;
    }
}

