/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.betterx.bclib.blocks.StalactiteBlock;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.world.features.terrain.StalactiteFeatureConfig;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class StalactiteFeature
extends Feature<StalactiteFeatureConfig> {
    public StalactiteFeature() {
        super(StalactiteFeatureConfig.CODEC);
    }

    public boolean place(FeaturePlaceContext<StalactiteFeatureConfig> featureConfig) {
        RandomSource random = featureConfig.random();
        BlockPos pos = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        StalactiteFeatureConfig cfg = (StalactiteFeatureConfig)featureConfig.config();
        if (!cfg.allowedGround.test((Object)world, (Object)(cfg.ceiling ? pos.above() : pos.below()))) {
            return false;
        }
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        int height = random.nextInt(16);
        int dir = cfg.ceiling ? -1 : 1;
        boolean stalagnate = false;
        for (int i = 1; i <= height; ++i) {
            mut.setY(pos.getY() + i * dir);
            BlockState state = world.getBlockState((BlockPos)mut);
            if (state.canBeReplaced()) continue;
            stalagnate = state.is(CommonBlockTags.END_STONES);
            height = i;
            break;
        }
        if (!stalagnate && height > 7) {
            height = random.nextInt(8);
        }
        float center = (float)height * 0.5f;
        for (int i = 0; i < height; ++i) {
            mut.setY(pos.getY() + i * dir);
            int size = stalagnate ? Mth.clamp((int)((int)(Mth.abs((float)((float)i - center)) + 1.0f)), (int)1, (int)7) : height - i - 1;
            boolean waterlogged = !world.getFluidState((BlockPos)mut).isEmpty();
            BlockState base = (BlockState)((BlockState)cfg.block.getState(random, (BlockPos)mut).setValue((Property)StalactiteBlock.SIZE, (Comparable)Integer.valueOf(size))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
            BlockState state = stalagnate ? (BlockState)base.setValue((Property)StalactiteBlock.IS_FLOOR, (Comparable)Boolean.valueOf(dir > 0 ? (float)i < center : (float)i > center)) : (BlockState)base.setValue((Property)StalactiteBlock.IS_FLOOR, (Comparable)Boolean.valueOf(dir > 0));
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)state);
        }
        return true;
    }
}

