/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluids;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.blocks.BuddingSmaragdantCrystalBlock;
import org.betterx.betterend.blocks.SmaragdantCrystalShardBlock;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class SmaragdantCrystalFeature
extends DefaultFeature {
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        RandomSource random = featureConfig.random();
        BlockPos pos = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        if (!world.getBlockState(pos.below()).is(CommonBlockTags.END_STONES)) {
            return false;
        }
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        int count = MHelper.randRange((int)15, (int)30, (RandomSource)random);
        BlockState crystal = EndBlocks.SMARAGDANT_CRYSTAL.defaultBlockState();
        BlockState shard = EndBlocks.SMARAGDANT_CRYSTAL_SHARD.defaultBlockState();
        BlockState buddingCrystal = EndBlocks.BUDDING_SMARAGDANT_CRYSTAL.defaultBlockState();
        for (int i = 0; i < count; ++i) {
            mut.set((Vec3i)pos).move(MHelper.floor((double)(random.nextGaussian() * 2.0 + 0.5)), 5, MHelper.floor((double)(random.nextGaussian() * 2.0 + 0.5)));
            int dist = MHelper.floor((double)(1.5f - MHelper.length((float)(mut.getX() - pos.getX()), (float)(mut.getZ() - pos.getZ())))) + random.nextInt(3);
            if (dist <= 0) continue;
            BlockState state = world.getBlockState((BlockPos)mut);
            for (int n = 0; n < 10 && state.isAir(); ++n) {
                mut.setY(mut.getY() - 1);
                state = world.getBlockState((BlockPos)mut);
            }
            if (!state.is(CommonBlockTags.END_STONES) || !world.getBlockState(mut.above()).isAir()) continue;
            for (int j = 0; j <= dist; ++j) {
                if (random.nextInt(8) == 0) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)buddingCrystal);
                    for (Direction k : BlocksHelper.HORIZONTAL) {
                        BlockPos sidePos = mut.relative(k);
                        BlockState sideState = world.getBlockState(sidePos);
                        if (!BuddingSmaragdantCrystalBlock.canShardGrowAtState(sideState) || !random.nextBoolean()) continue;
                        BlockState attachedShard = (BlockState)((BlockState)EndBlocks.SMARAGDANT_CRYSTAL_SHARD.defaultBlockState().setValue((Property)SmaragdantCrystalShardBlock.WATERLOGGED, (Comparable)Boolean.valueOf(sideState.getFluidState().getType() == Fluids.WATER))).setValue((Property)SmaragdantCrystalShardBlock.FACING, (Comparable)k);
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)sidePos, (BlockState)attachedShard);
                    }
                } else {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)crystal);
                }
                mut.setY(mut.getY() + 1);
            }
            boolean waterlogged = !world.getFluidState((BlockPos)mut).isEmpty();
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)((BlockState)shard.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))));
        }
        return true;
    }
}

