/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class SingleBlockFeature
extends Feature<SimpleBlockConfiguration> {
    public SingleBlockFeature() {
        super(SimpleBlockConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<SimpleBlockConfiguration> featureConfig) {
        RandomSource random = featureConfig.random();
        BlockPos pos = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        SimpleBlockConfiguration cfg = (SimpleBlockConfiguration)featureConfig.config();
        if (!world.getBlockState(pos.below()).is(CommonBlockTags.END_STONES)) {
            return false;
        }
        BlockState state = cfg.toPlace().getState(random, pos);
        if (state.getBlock().getStateDefinition().getProperty("waterlogged") != null) {
            boolean waterlogged = !world.getFluidState(pos).isEmpty();
            state = (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
        }
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)state);
        return true;
    }
}

