/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.betterx.bclib.sdf.PosInfo;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFRotation;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.operator.SDFUnion;
import org.betterx.bclib.sdf.primitive.SDFCappedCone;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.world.features.terrain.IceStarFeatureConfig;
import org.joml.Vector3f;

public class IceStarFeature
extends Feature<IceStarFeatureConfig> {
    public IceStarFeature() {
        super(IceStarFeatureConfig.CODEC);
    }

    public boolean place(FeaturePlaceContext<IceStarFeatureConfig> featureConfig) {
        RandomSource random = featureConfig.random();
        BlockPos pos = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        IceStarFeatureConfig cfg = (IceStarFeatureConfig)featureConfig.config();
        float size = MHelper.randRange((float)cfg.minSize, (float)cfg.maxSize, (RandomSource)random);
        int count = MHelper.randRange((int)cfg.minCount, (int)cfg.maxCount, (RandomSource)random);
        List<Vector3f> points = this.getFibonacciPoints(count);
        SDFPrimitive sdf = null;
        SDFPrimitive spike = new SDFCappedCone().setRadius1(3.0f + (size - 5.0f) * 0.2f).setRadius2(0.0f).setHeight(size).setBlock(EndBlocks.DENSE_SNOW);
        spike = new SDFTranslate().setTranslate(0.0f, size - 0.5f, 0.0f).setSource((SDF)spike);
        for (Vector3f point : points) {
            SDFPrimitive rotated = spike;
            float angle = MHelper.angle((Vector3f)MHelper.YP, (Vector3f)(point = MHelper.normalize((Vector3f)point)));
            if (angle > 0.01f && angle < 3.14f) {
                Vector3f axis = MHelper.normalize((Vector3f)MHelper.cross((Vector3f)MHelper.YP, (Vector3f)point));
                rotated = new SDFRotation().setRotation(axis, angle).setSource((SDF)spike);
            } else if (angle > 1.0f) {
                rotated = new SDFRotation().setRotation(MHelper.YP, (float)Math.PI).setSource((SDF)spike);
            }
            sdf = sdf == null ? rotated : new SDFUnion().setSourceA((SDF)sdf).setSourceB((SDF)rotated);
        }
        int x1 = pos.getX() >> 4 << 4;
        int z1 = pos.getZ() >> 4 << 4;
        pos = new BlockPos(x1 + random.nextInt(16), MHelper.randRange((int)32, (int)128, (RandomSource)random), z1 + random.nextInt(16));
        float ancientRadius = size * 0.7f;
        float denseRadius = size * 0.9f;
        float iceRadius = size < 7.0f ? size * 5.0f : size * 1.3f;
        float randScale = size * 0.3f;
        BlockPos center = pos;
        BlockState ice = EndBlocks.EMERALD_ICE.defaultBlockState();
        BlockState dense = EndBlocks.DENSE_EMERALD_ICE.defaultBlockState();
        BlockState ancient = EndBlocks.ANCIENT_EMERALD_ICE.defaultBlockState();
        SDFPrimitive sdfCopy = sdf;
        sdf.addPostProcess(arg_0 -> IceStarFeature.lambda$place$0(center, (SDF)sdfCopy, random, randScale, ancientRadius, ancient, denseRadius, dense, iceRadius, ice, arg_0)).fillRecursive((ServerLevelAccessor)world, pos);
        return true;
    }

    private List<Vector3f> getFibonacciPoints(int count) {
        float max = count - 1;
        ArrayList<Vector3f> result = new ArrayList<Vector3f>(count);
        for (int i = 0; i < count; ++i) {
            float y = 1.0f - (float)i / max * 2.0f;
            float radius = (float)Math.sqrt(1.0f - y * y);
            float theta = MHelper.PHI * (float)i;
            float x = (float)Math.cos(theta) * radius;
            float z = (float)Math.sin(theta) * radius;
            result.add(new Vector3f(x, y, z));
        }
        return result;
    }

    private static /* synthetic */ BlockState lambda$place$0(BlockPos center, SDF sdfCopy, RandomSource random, float randScale, float ancientRadius, BlockState ancient, float denseRadius, BlockState dense, float iceRadius, BlockState ice, PosInfo info) {
        float pz;
        float py;
        BlockPos bpos = info.getPos();
        float px = bpos.getX() - center.getX();
        float distance = MHelper.length((float)px, (float)(py = (float)(bpos.getY() - center.getY())), (float)(pz = (float)(bpos.getZ() - center.getZ()))) + sdfCopy.getDistance(px, py, pz) * 0.4f + random.nextFloat() * randScale;
        if (distance < ancientRadius) {
            return ancient;
        }
        if (distance < denseRadius) {
            return dense;
        }
        if (distance < iceRadius) {
            return ice;
        }
        return info.getState();
    }
}

