/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFDisplacement;
import org.betterx.bclib.sdf.operator.SDFRotation;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.primitive.SDFCappedCone;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;
import org.joml.Vector3f;

public class FallenPillarFeature
extends DefaultFeature {
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        RandomSource random = featureConfig.random();
        BlockPos pos = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        if (!world.getBlockState((pos = FallenPillarFeature.getPosOnSurface((WorldGenLevel)world, (BlockPos)new BlockPos(pos.getX() + random.nextInt(16), pos.getY(), pos.getZ() + random.nextInt(16)))).below(5)).is(CommonBlockTags.END_STONES) || !world.getBlockState(pos).isAir()) {
            return false;
        }
        float height = MHelper.randRange((float)20.0f, (float)40.0f, (RandomSource)random);
        float radius = MHelper.randRange((float)2.0f, (float)4.0f, (RandomSource)random);
        SDFPrimitive pillar = new SDFCappedCone().setRadius1(radius).setRadius2(radius).setHeight(height * 0.5f).setBlock(Blocks.OBSIDIAN);
        pillar = new SDFTranslate().setTranslate(0.0f, radius * 0.5f - 2.0f, 0.0f).setSource((SDF)pillar);
        OpenSimplexNoise noise = new OpenSimplexNoise(random.nextLong());
        pillar = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)(noise.eval((double)vec.x() * 0.3, (double)vec.y() * 0.3, (double)vec.z() * 0.3) * 0.5))).setSource((SDF)pillar);
        Vector3f vec2 = MHelper.randomHorizontal((RandomSource)random);
        float angle = (float)random.nextGaussian() * 0.05f + (float)Math.PI;
        pillar = new SDFRotation().setRotation(vec2, angle).setSource((SDF)pillar);
        BlockState mossy = EndBlocks.MOSSY_OBSIDIAN.defaultBlockState();
        pillar.addPostProcess(info -> {
            if (info.getStateUp().isAir() && random.nextFloat() > 0.1f) {
                return mossy;
            }
            return info.getState();
        }).setReplaceFunction(state -> state.is(CommonBlockTags.END_STONES) || BlocksHelper.replaceableOrPlant((BlockState)state) != false).fillRecursive((ServerLevelAccessor)world, pos);
        return true;
    }
}

