/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.FluidState;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.util.BlockFixer;
import org.betterx.betterend.util.GlobalState;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class DesertLakeFeature
extends DefaultFeature {
    private static final BlockState END_STONE = Blocks.END_STONE.defaultBlockState();
    private static final OpenSimplexNoise NOISE = new OpenSimplexNoise(15152L);

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        BlockState state;
        double r;
        int y;
        int x;
        BlockPos.MutableBlockPos POS = GlobalState.stateForThread().POS;
        RandomSource random = featureConfig.random();
        BlockPos blockPos = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        double radius = MHelper.randRange((double)8.0, (double)15.0, (RandomSource)random);
        double depth = radius * 0.5 * MHelper.randRange((double)0.8, (double)1.2, (RandomSource)random);
        int dist = MHelper.floor((double)radius);
        int dist2 = MHelper.floor((double)(radius * 1.5));
        int bott = MHelper.floor((double)depth);
        if ((blockPos = DesertLakeFeature.getPosOnSurfaceWG((WorldGenLevel)world, (BlockPos)blockPos)).getY() < 10) {
            return false;
        }
        int waterLevel = blockPos.getY();
        BlockPos pos = DesertLakeFeature.getPosOnSurfaceRaycast((WorldGenLevel)world, (BlockPos)blockPos.north(dist).above(10), (int)20);
        if (Math.abs(blockPos.getY() - pos.getY()) > 5) {
            return false;
        }
        waterLevel = MHelper.min((int)pos.getY(), (int)waterLevel);
        pos = DesertLakeFeature.getPosOnSurfaceRaycast((WorldGenLevel)world, (BlockPos)blockPos.south(dist).above(10), (int)20);
        if (Math.abs(blockPos.getY() - pos.getY()) > 5) {
            return false;
        }
        waterLevel = MHelper.min((int)pos.getY(), (int)waterLevel);
        pos = DesertLakeFeature.getPosOnSurfaceRaycast((WorldGenLevel)world, (BlockPos)blockPos.east(dist).above(10), (int)20);
        if (Math.abs(blockPos.getY() - pos.getY()) > 5) {
            return false;
        }
        waterLevel = MHelper.min((int)pos.getY(), (int)waterLevel);
        pos = DesertLakeFeature.getPosOnSurfaceRaycast((WorldGenLevel)world, (BlockPos)blockPos.west(dist).above(10), (int)20);
        if (Math.abs(blockPos.getY() - pos.getY()) > 5) {
            return false;
        }
        waterLevel = MHelper.min((int)pos.getY(), (int)waterLevel);
        int minX = blockPos.getX() - dist2;
        int maxX = blockPos.getX() + dist2;
        int minZ = blockPos.getZ() - dist2;
        int maxZ = blockPos.getZ() + dist2;
        int maskMinX = minX - 1;
        int maskMinZ = minZ - 1;
        boolean[][] mask = new boolean[maxX - minX + 3][maxZ - minZ + 3];
        for (x = minX; x <= maxX; ++x) {
            POS.setX(x);
            int mx = x - maskMinX;
            block1: for (int z = minZ; z <= maxZ; ++z) {
                POS.setZ(z);
                int mz = z - maskMinZ;
                if (mask[mx][mz]) continue;
                for (int y2 = waterLevel + 1; y2 <= waterLevel + 20; ++y2) {
                    POS.setY(y2);
                    FluidState fluid = world.getFluidState((BlockPos)POS);
                    if (fluid.isEmpty()) continue;
                    for (int i = -1; i < 2; ++i) {
                        int px = mx + i;
                        for (int j = -1; j < 2; ++j) {
                            int pz = mz + j;
                            mask[px][pz] = true;
                        }
                    }
                    continue block1;
                }
            }
        }
        for (x = minX; x <= maxX; ++x) {
            POS.setX(x);
            int x2 = x - blockPos.getX();
            x2 *= x2;
            int mx = x - maskMinX;
            block6: for (int z = minZ; z <= maxZ; ++z) {
                POS.setZ(z);
                int z2 = z - blockPos.getZ();
                z2 *= z2;
                int mz = z - maskMinZ;
                if (mask[mx][mz]) continue;
                double size = 1.0;
                for (y = blockPos.getY(); y <= blockPos.getY() + 20; ++y) {
                    POS.setY(y);
                    double add = y - blockPos.getY();
                    if (add > 5.0) {
                        size *= 0.8;
                        add = 5.0;
                    }
                    if (!((r = add * 1.8 + radius * (NOISE.eval((double)x * 0.2, (double)y * 0.2, (double)z * 0.2) * 0.25 + 0.75) - 1.0 / size) > 0.0)) continue block6;
                    if (!((double)(x2 + z2) <= (r *= r))) continue;
                    state = world.getBlockState((BlockPos)POS);
                    if (state.is(CommonBlockTags.END_STONES)) {
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)POS, (BlockState)AIR);
                    }
                    if (!world.getBlockState(pos = POS.below()).is(CommonBlockTags.END_STONES)) continue;
                    state = EndBiome.findTopMaterial(world, pos);
                    if (y > waterLevel + 1) {
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)state);
                        continue;
                    }
                    if (y > waterLevel) {
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)(random.nextBoolean() ? state : EndBlocks.ENDSTONE_DUST.defaultBlockState()));
                        continue;
                    }
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)EndBlocks.ENDSTONE_DUST.defaultBlockState());
                }
            }
        }
        double aspect = radius / depth;
        for (int x2 = blockPos.getX() - dist; x2 <= blockPos.getX() + dist; ++x2) {
            POS.setX(x2);
            int x22 = x2 - blockPos.getX();
            x22 *= x22;
            int mx = x2 - maskMinX;
            for (int z = blockPos.getZ() - dist; z <= blockPos.getZ() + dist; ++z) {
                POS.setZ(z);
                int z2 = z - blockPos.getZ();
                z2 *= z2;
                int mz = z - maskMinZ;
                if (mask[mx][mz]) continue;
                for (y = blockPos.getY() - bott; y < blockPos.getY(); ++y) {
                    POS.setY(y);
                    double y2 = (double)(y - blockPos.getY()) * aspect;
                    y2 *= y2;
                    r = radius * (NOISE.eval((double)x2 * 0.2, (double)y * 0.2, (double)z * 0.2) * 0.25 + 0.75);
                    double rb = r * 1.2;
                    r *= r;
                    rb *= rb;
                    if (y2 + (double)x22 + (double)z2 <= r) {
                        state = world.getBlockState((BlockPos)POS);
                        if (this.canReplace(state)) {
                            state = world.getBlockState(POS.above());
                            state = this.canReplace(state) ? (y < waterLevel ? WATER : AIR) : state;
                            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)POS, (BlockState)state);
                        }
                        if (world.getBlockState(pos = POS.below()).is(CommonBlockTags.END_STONES)) {
                            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)EndBlocks.ENDSTONE_DUST.defaultBlockState());
                        }
                        pos = POS.above();
                        while (this.canReplace(state = world.getBlockState(pos)) && !state.isAir() && state.getFluidState().isEmpty()) {
                            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)(pos.getY() < waterLevel ? WATER : AIR));
                            pos = pos.above();
                        }
                        continue;
                    }
                    if (!(y2 + (double)x22 + (double)z2 <= rb)) continue;
                    state = world.getBlockState((BlockPos)POS);
                    if (state.is(CommonBlockTags.END_STONES) && world.isEmptyBlock(POS.above())) {
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)POS, (Block)EndBlocks.END_MOSS);
                        continue;
                    }
                    if (y >= waterLevel) continue;
                    if (world.isEmptyBlock(POS.above())) {
                        state = EndBiome.findTopMaterial(world, pos);
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)POS, (BlockState)(random.nextBoolean() ? state : EndBlocks.ENDSTONE_DUST.defaultBlockState()));
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)POS.below(), (BlockState)END_STONE);
                        continue;
                    }
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)POS, (BlockState)EndBlocks.ENDSTONE_DUST.defaultBlockState());
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)POS.below(), (BlockState)END_STONE);
                }
            }
        }
        BlockFixer.fixBlocks((LevelAccessor)world, new BlockPos(minX - 2, waterLevel - 2, minZ - 2), new BlockPos(maxX + 2, blockPos.getY() + 20, maxZ + 2));
        return true;
    }

    private boolean canReplace(BlockState state) {
        return state.is(CommonBlockTags.END_STONES) || state.is(EndBlocks.ENDSTONE_DUST) || BlocksHelper.replaceableOrPlant((BlockState)state) != false || state.is(CommonBlockTags.WATER_PLANT);
    }
}

