/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import org.betterx.betterend.world.biome.land.UmbraValleyBiome;

public class ArchFeatureConfig
implements FeatureConfiguration {
    public static final Codec<ArchFeatureConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("states").forGetter(o -> o.block), (App)SurfaceFunction.CODEC.fieldOf("surface_function").forGetter(o -> o.surfaceFunction)).apply((Applicative)instance, ArchFeatureConfig::new));
    public final BlockStateProvider block;
    public final SurfaceFunction surfaceFunction;

    public ArchFeatureConfig(Block block, SurfaceFunction surfaceFunction) {
        this((BlockStateProvider)SimpleStateProvider.simple((Block)block), surfaceFunction);
    }

    public ArchFeatureConfig(BlockStateProvider block, SurfaceFunction surfaceFunction) {
        this.block = block;
        this.surfaceFunction = surfaceFunction;
    }

    public static enum SurfaceFunction implements StringRepresentable
    {
        UMBRA_VALLEY("umbra_valley", pos -> UmbraValleyBiome.getSurface(pos.getX(), pos.getZ()).defaultBlockState());

        public static final Codec<SurfaceFunction> CODEC;
        private final Function<BlockPos, BlockState> surfaceFunction;
        private final String name;

        private SurfaceFunction(String name, Function<BlockPos, BlockState> surfaceFunction) {
            this.name = name;
            this.surfaceFunction = surfaceFunction;
        }

        public String getSerializedName() {
            return this.name;
        }

        public BlockState apply(BlockPos pos) {
            return this.surfaceFunction.apply(pos);
        }

        static {
            CODEC = StringRepresentable.fromEnum(SurfaceFunction::values);
        }
    }
}

