/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFDisplacement;
import org.betterx.bclib.sdf.operator.SDFRotation;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.sdf.primitive.SDFTorus;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.world.features.terrain.ArchFeatureConfig;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class ArchFeature
extends Feature<ArchFeatureConfig> {
    public ArchFeature() {
        super(ArchFeatureConfig.CODEC);
    }

    public boolean place(FeaturePlaceContext<ArchFeatureConfig> featurePlaceContext) {
        ArchFeatureConfig cfg = (ArchFeatureConfig)featurePlaceContext.config();
        WorldGenLevel world = featurePlaceContext.level();
        BlockPos origin = featurePlaceContext.origin();
        RandomSource random = featurePlaceContext.random();
        BlockState cfgBlockState = cfg.block.getState(random, origin);
        Block cfgBlock = cfgBlockState.getBlock();
        BlockPos pos = DefaultFeature.getPosOnSurfaceWG((WorldGenLevel)world, (BlockPos)new BlockPos(origin.getX() & 0xFFFFFFF0 | 7, 0, origin.getZ() & 0xFFFFFFF0 | 7));
        if (!world.getBlockState(pos.below(5)).is(CommonBlockTags.END_STONES)) {
            return false;
        }
        float bigRadius = MHelper.randRange((float)10.0f, (float)20.0f, (RandomSource)random);
        float smallRadius = MHelper.randRange((float)3.0f, (float)7.0f, (RandomSource)random);
        if (smallRadius + bigRadius > 23.0f) {
            smallRadius = 23.0f - bigRadius;
        }
        SDFPrimitive arch = new SDFTorus().setBigRadius(bigRadius).setSmallRadius(smallRadius).setBlock(cfgBlock);
        arch = new SDFRotation().setRotation(MHelper.randomHorizontal((RandomSource)random), 1.5707964f).setSource((SDF)arch);
        float smallRadiusF = smallRadius;
        OpenSimplexNoise noise = new OpenSimplexNoise(random.nextLong());
        arch = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)(Math.abs(noise.eval((double)vec.x() * 0.1, (double)vec.y() * 0.1, (double)vec.z() * 0.1)) * 3.0 + Math.abs(noise.eval((double)vec.x() * 0.3, (double)vec.y() * 0.3 + 100.0, (double)vec.z() * 0.3)) * (double)1.3f) - smallRadiusF * Math.abs(1.0f - vec.y() / bigRadius))).setSource((SDF)arch);
        arch.addPostProcess(info -> {
            if (info.getStateUp().isAir()) {
                return cfg.surfaceFunction.apply(info.getPos());
            }
            return info.getState();
        });
        float side = (bigRadius + smallRadius + 3.0f) * 2.0f;
        if (side > 47.0f) {
            side = 47.0f;
        }
        arch.fillArea((ServerLevelAccessor)world, pos, AABB.ofSize((Vec3)Vec3.atCenterOf((Vec3i)pos), (double)side, (double)side, (double)side));
        return true;
    }
}

