/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.bushes;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFDisplacement;
import org.betterx.bclib.sdf.operator.SDFScale3D;
import org.betterx.bclib.sdf.operator.SDFSubtraction;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.sdf.primitive.SDFSphere;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.blocks.basis.FurBlock;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.wover.block.api.BlockProperties;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class TenaneaBushFeature
extends DefaultFeature {
    private static final Function<BlockState, Boolean> REPLACE;
    private static final Direction[] DIRECTIONS;

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        RandomSource random = featureConfig.random();
        BlockPos pos = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        if (!world.getBlockState(pos.below()).is(CommonBlockTags.END_STONES)) {
            return false;
        }
        float radius = MHelper.randRange((float)1.8f, (float)3.5f, (RandomSource)random);
        OpenSimplexNoise noise = new OpenSimplexNoise(random.nextInt());
        BlockState leaves = EndBlocks.TENANEA_LEAVES.defaultBlockState();
        SDFPrimitive sphere = new SDFSphere().setRadius(radius).setBlock(leaves);
        sphere = new SDFScale3D().setScale(1.0f, 0.75f, 1.0f).setSource((SDF)sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval((double)vec.x() * 0.2, (double)vec.y() * 0.2, (double)vec.z() * 0.2) * 3.0f)).setSource((SDF)sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf(MHelper.randRange((float)-2.0f, (float)2.0f, (RandomSource)random))).setSource((SDF)sphere);
        sphere = new SDFSubtraction().setSourceA((SDF)sphere).setSourceB((SDF)new SDFTranslate().setTranslate(0.0f, -radius, 0.0f).setSource((SDF)sphere));
        sphere.setReplaceFunction(REPLACE);
        ArrayList support = Lists.newArrayList();
        sphere.addPostProcess(info -> {
            if (info.getState().getBlock() instanceof LeavesBlock) {
                int distance = info.getPos().distManhattan((Vec3i)pos);
                if (distance < 7) {
                    if (random.nextInt(4) == 0 && info.getStateDown().isAir()) {
                        BlockPos d = info.getPos().below();
                        support.add(d);
                    }
                    MHelper.shuffle((Object[])DIRECTIONS, (RandomSource)random);
                    for (Direction d : DIRECTIONS) {
                        if (!info.getState(d).isAir()) continue;
                        info.setBlockPos(info.getPos().relative(d), (BlockState)EndBlocks.TENANEA_OUTER_LEAVES.defaultBlockState().setValue((Property)FurBlock.FACING, (Comparable)d));
                    }
                    return (BlockState)info.getState().setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(distance));
                }
                return AIR;
            }
            return info.getState();
        });
        sphere.fillRecursive((ServerLevelAccessor)world, pos);
        BlockState stem = EndBlocks.TENANEA.getBark().defaultBlockState();
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)stem);
        for (Direction d : Direction.values()) {
            BlockPos p = pos.relative(d);
            if (!world.isEmptyBlock(p)) continue;
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)p, (BlockState)((BlockState)leaves.setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1))));
        }
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        BlockState top = (BlockState)EndBlocks.TENANEA_FLOWERS.defaultBlockState().setValue((Property)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.TOP);
        BlockState middle = (BlockState)EndBlocks.TENANEA_FLOWERS.defaultBlockState().setValue((Property)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE);
        BlockState bottom = (BlockState)EndBlocks.TENANEA_FLOWERS.defaultBlockState().setValue((Property)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM);
        support.forEach(bpos -> {
            BlockState state = world.getBlockState(bpos);
            if (state.isAir() || state.is(EndBlocks.TENANEA_OUTER_LEAVES)) {
                int count = MHelper.randRange((int)3, (int)8, (RandomSource)random);
                mut.set((Vec3i)bpos);
                if (world.getBlockState(mut.above()).is(EndBlocks.TENANEA_LEAVES)) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)top);
                    for (int i = 1; i < count; ++i) {
                        mut.setY(mut.getY() - 1);
                        if (!world.isEmptyBlock(mut.below())) break;
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)middle);
                    }
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)bottom);
                }
            }
        });
        return true;
    }

    static {
        DIRECTIONS = Direction.values();
        REPLACE = BlocksHelper::replaceableOrPlant;
    }
}

