/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.bushes;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFDisplacement;
import org.betterx.bclib.sdf.operator.SDFScale3D;
import org.betterx.bclib.sdf.operator.SDFSubtraction;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.sdf.primitive.SDFSphere;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.world.features.bushes.BushFeatureConfig;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class BushFeature
extends Feature<BushFeatureConfig> {
    private static final Function<BlockState, Boolean> REPLACE = BlocksHelper::replaceableOrPlant;

    public BushFeature() {
        super(BushFeatureConfig.CODEC);
    }

    public boolean place(FeaturePlaceContext<BushFeatureConfig> featureConfig) {
        RandomSource random = featureConfig.random();
        BlockPos pos = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        if (!world.getBlockState(pos.below()).is(CommonBlockTags.END_STONES) && !world.getBlockState(pos.above()).is(CommonBlockTags.END_STONES)) {
            return false;
        }
        BushFeatureConfig cfg = (BushFeatureConfig)featureConfig.config();
        Block leaves = cfg.leaves.getState(random, pos).getBlock();
        BlockState stem = cfg.stem.getState(random, pos);
        float radius = MHelper.randRange((float)1.8f, (float)3.5f, (RandomSource)random);
        OpenSimplexNoise noise = new OpenSimplexNoise(random.nextInt());
        SDFPrimitive sphere = new SDFSphere().setRadius(radius).setBlock(leaves);
        sphere = new SDFScale3D().setScale(1.0f, 0.5f, 1.0f).setSource((SDF)sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval((double)vec.x() * 0.2, (double)vec.y() * 0.2, (double)vec.z() * 0.2) * 3.0f)).setSource((SDF)sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf(MHelper.randRange((float)-2.0f, (float)2.0f, (RandomSource)random))).setSource((SDF)sphere);
        sphere = new SDFSubtraction().setSourceA((SDF)sphere).setSourceB((SDF)new SDFTranslate().setTranslate(0.0f, -radius, 0.0f).setSource((SDF)sphere));
        sphere.setReplaceFunction(REPLACE);
        sphere.addPostProcess(info -> {
            if (info.getState().getBlock() instanceof LeavesBlock) {
                int distance = info.getPos().distManhattan((Vec3i)pos);
                if (distance < 7) {
                    return (BlockState)info.getState().setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(distance));
                }
                return DefaultFeature.AIR;
            }
            return info.getState();
        });
        sphere.fillRecursive((ServerLevelAccessor)world, pos);
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)stem);
        for (Direction d : Direction.values()) {
            BlockPos p = pos.relative(d);
            if (!world.isEmptyBlock(p)) continue;
            if (leaves instanceof LeavesBlock) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)p, (BlockState)((BlockState)leaves.defaultBlockState().setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1))));
                continue;
            }
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)p, (BlockState)leaves.defaultBlockState());
        }
        return true;
    }
}

