/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import org.betterx.betterend.world.features.ScatterFeatureConfig;

public class VineFeatureConfig
extends ScatterFeatureConfig {
    public static final Codec<VineFeatureConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("state").forGetter(o -> o.plant), (App)Codec.INT.fieldOf("radius").forGetter(o -> o.radius), (App)Codec.INT.fieldOf("max_length").forGetter(o -> o.maxLength)).apply((Applicative)instance, VineFeatureConfig::new));
    public final BlockStateProvider plant;
    public final int maxLength;

    public VineFeatureConfig(Block vineBlock, int maxLength) {
        this((BlockStateProvider)SimpleStateProvider.simple((Block)vineBlock), 6, maxLength);
    }

    public VineFeatureConfig(BlockStateProvider plant, int radius, int maxLength) {
        super(radius);
        this.plant = plant;
        this.maxLength = maxLength;
    }

    public BlockState getPlantState(RandomSource rnd, BlockPos pos) {
        return this.plant.getState(rnd, pos);
    }
}

