/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import org.betterx.betterend.util.GlobalState;
import org.betterx.betterend.world.features.ScatterFeature;
import org.betterx.betterend.world.features.ScatterFeatureConfig;

public abstract class UnderwaterPlantScatter<FC extends ScatterFeatureConfig>
extends ScatterFeature<FC> {
    public UnderwaterPlantScatter(Codec<FC> codec) {
        super(codec);
    }

    @Override
    protected BlockPos getCenterGround(FC cfg, WorldGenLevel world, BlockPos pos) {
        BlockPos.MutableBlockPos POS = GlobalState.stateForThread().POS;
        POS.setX(pos.getX());
        POS.setZ(pos.getZ());
        POS.setY(0);
        return this.getGround(world, POS).immutable();
    }

    @Override
    public boolean canGenerate(FC cfg, WorldGenLevel world, RandomSource random, BlockPos center, BlockPos blockPos, float radius) {
        return world.getBlockState(blockPos).is(Blocks.WATER);
    }

    @Override
    protected boolean canSpawn(FC cfg, WorldGenLevel world, BlockPos pos) {
        return world.getBlockState(pos).is(Blocks.WATER);
    }

    @Override
    protected boolean getGroundPlant(FC cfg, WorldGenLevel world, BlockPos.MutableBlockPos pos) {
        return this.getGround(world, pos).getY() < 128;
    }

    @Override
    protected int getYOffset() {
        return -5;
    }

    @Override
    protected int getChance() {
        return 5;
    }

    private BlockPos getGround(WorldGenLevel world, BlockPos.MutableBlockPos pos) {
        while (pos.getY() < 128 && world.getFluidState((BlockPos)pos).isEmpty()) {
            pos.setY(pos.getY() + 1);
        }
        return pos;
    }
}

