/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.blocks.BaseCropBlock;
import org.betterx.bclib.blocks.BaseDoublePlantBlock;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.blocks.basis.EndPlantWithAgeBlock;
import org.betterx.betterend.world.features.ScatterFeature;
import org.betterx.betterend.world.features.SinglePlantFeatureConfig;

public class SinglePlantFeature
extends ScatterFeature<SinglePlantFeatureConfig> {
    BlockState plant;

    public SinglePlantFeature() {
        super(SinglePlantFeatureConfig.CODEC);
    }

    @Override
    protected BlockPos getCenterGround(SinglePlantFeatureConfig cfg, WorldGenLevel world, BlockPos pos) {
        return cfg.rawHeightmap ? DefaultFeature.getPosOnSurfaceWG((WorldGenLevel)world, (BlockPos)pos) : DefaultFeature.getPosOnSurface((WorldGenLevel)world, (BlockPos)pos);
    }

    @Override
    public boolean canGenerate(SinglePlantFeatureConfig cfg, WorldGenLevel world, RandomSource random, BlockPos center, BlockPos blockPos, float radius) {
        this.plant = cfg.getPlantState(random, blockPos);
        return this.plant.canSurvive((LevelReader)world, blockPos);
    }

    @Override
    public void generate(SinglePlantFeatureConfig cfg, WorldGenLevel world, RandomSource random, BlockPos blockPos) {
        if (this.plant.getBlock() instanceof BaseDoublePlantBlock) {
            int rot = random.nextInt(4);
            BlockState state = (BlockState)this.plant.setValue((Property)BaseDoublePlantBlock.ROTATION, (Comparable)Integer.valueOf(rot));
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)blockPos, (BlockState)state);
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)blockPos.above(), (BlockState)((BlockState)state.setValue((Property)BaseDoublePlantBlock.TOP, (Comparable)Boolean.valueOf(true))));
        } else if (this.plant.getBlock() instanceof BaseCropBlock) {
            BlockState state = (BlockState)this.plant.setValue((Property)BaseCropBlock.AGE, (Comparable)Integer.valueOf(3));
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)blockPos, (BlockState)state);
        } else if (this.plant.getBlock() instanceof EndPlantWithAgeBlock) {
            int age = random.nextInt(4);
            BlockState state = (BlockState)this.plant.setValue((Property)EndPlantWithAgeBlock.AGE, (Comparable)Integer.valueOf(age));
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)blockPos, (BlockState)state);
        } else {
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)blockPos, (BlockState)this.plant);
        }
    }
}

