/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.blocks.BaseAttachedBlock;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.world.features.InvertedScatterFeature;
import org.betterx.betterend.world.features.SinglePlantFeatureConfig;

public class SingleInvertedScatterFeature
extends InvertedScatterFeature<SinglePlantFeatureConfig> {
    private BlockState block;

    public SingleInvertedScatterFeature() {
        super(SinglePlantFeatureConfig.CODEC);
    }

    @Override
    public boolean canGenerate(SinglePlantFeatureConfig cfg, WorldGenLevel world, RandomSource random, BlockPos center, BlockPos blockPos, float radius) {
        if (!world.isEmptyBlock(blockPos)) {
            return false;
        }
        BlockState state = this.block = cfg.getPlantState(random, blockPos);
        if (this.block.getBlock() instanceof BaseAttachedBlock) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN);
        }
        return state.canSurvive((LevelReader)world, blockPos);
    }

    @Override
    public void generate(SinglePlantFeatureConfig cfg, WorldGenLevel world, RandomSource random, BlockPos blockPos) {
        BlockState state = this.block;
        if (this.block.getBlock() instanceof BaseAttachedBlock) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN);
        }
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)blockPos, (BlockState)state);
    }
}

