/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.api.v2.levelgen.structures.templatesystem.DestructionStructureProcessor;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.features.NBTFeatureConfig;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public abstract class NBTFeature<FC extends NBTFeatureConfig>
extends Feature<FC> {
    protected static final DestructionStructureProcessor DESTRUCTION = new DestructionStructureProcessor();

    public NBTFeature(Codec<FC> codec) {
        super(codec);
    }

    protected abstract StructureTemplate getStructure(FC var1, WorldGenLevel var2, BlockPos var3, RandomSource var4);

    protected abstract boolean canSpawn(WorldGenLevel var1, BlockPos var2, RandomSource var3);

    protected abstract Rotation getRotation(WorldGenLevel var1, BlockPos var2, RandomSource var3);

    protected abstract Mirror getMirror(WorldGenLevel var1, BlockPos var2, RandomSource var3);

    protected abstract int getYOffset(StructureTemplate var1, WorldGenLevel var2, BlockPos var3, RandomSource var4);

    protected abstract TerrainMerge getTerrainMerge(WorldGenLevel var1, BlockPos var2, RandomSource var3);

    protected abstract void addStructureData(StructurePlaceSettings var1);

    protected BlockPos getGround(WorldGenLevel world, BlockPos center) {
        Holder biome = world.getBiome(center);
        ResourceLocation id = biome.unwrapKey().map(ResourceKey::location).orElse(null);
        if (id != null && (id.getNamespace().contains("moutain") || id.getNamespace().contains("lake"))) {
            int y = this.getAverageY(world, center);
            return new BlockPos(center.getX(), y, center.getZ());
        }
        int y = this.getAverageYWG(world, center);
        return new BlockPos(center.getX(), y, center.getZ());
    }

    protected int getAverageY(WorldGenLevel world, BlockPos center) {
        int y = DefaultFeature.getYOnSurface((WorldGenLevel)world, (int)center.getX(), (int)center.getZ());
        y += DefaultFeature.getYOnSurface((WorldGenLevel)world, (int)(center.getX() - 2), (int)(center.getZ() - 2));
        y += DefaultFeature.getYOnSurface((WorldGenLevel)world, (int)(center.getX() + 2), (int)(center.getZ() - 2));
        y += DefaultFeature.getYOnSurface((WorldGenLevel)world, (int)(center.getX() - 2), (int)(center.getZ() + 2));
        return (y += DefaultFeature.getYOnSurface((WorldGenLevel)world, (int)(center.getX() + 2), (int)(center.getZ() + 2))) / 5;
    }

    protected int getAverageYWG(WorldGenLevel world, BlockPos center) {
        int y = DefaultFeature.getYOnSurfaceWG((WorldGenLevel)world, (int)center.getX(), (int)center.getZ());
        y += DefaultFeature.getYOnSurfaceWG((WorldGenLevel)world, (int)(center.getX() - 2), (int)(center.getZ() - 2));
        y += DefaultFeature.getYOnSurfaceWG((WorldGenLevel)world, (int)(center.getX() + 2), (int)(center.getZ() - 2));
        y += DefaultFeature.getYOnSurfaceWG((WorldGenLevel)world, (int)(center.getX() - 2), (int)(center.getZ() + 2));
        return (y += DefaultFeature.getYOnSurfaceWG((WorldGenLevel)world, (int)(center.getX() + 2), (int)(center.getZ() + 2))) / 5;
    }

    public boolean place(FeaturePlaceContext<FC> context) {
        NBTFeatureConfig cfg = (NBTFeatureConfig)context.config();
        WorldGenLevel world = context.level();
        RandomSource random = context.random();
        BlockPos center = context.origin();
        center = new BlockPos(center.getX() >> 4 << 4 | 8, 128, center.getZ() >> 4 << 4 | 8);
        if (!this.canSpawn(world, center = this.getGround(world, center), random)) {
            return false;
        }
        int posY = center.getY() + 1;
        StructureTemplate structure = this.getStructure(cfg, world, center, random);
        Rotation rotation = this.getRotation(world, center, random);
        Mirror mirror = this.getMirror(world, center, random);
        BlockPos offset = StructureTemplate.transform((BlockPos)new BlockPos(structure.getSize()), (Mirror)mirror, (Rotation)rotation, (BlockPos)BlockPos.ZERO);
        center = center.offset(0, (int)((double)this.getYOffset(structure, world, center, random) + 0.5), 0);
        BoundingBox bounds = this.makeBox(center);
        StructurePlaceSettings placementData = new StructurePlaceSettings().setRotation(rotation).setMirror(mirror).setBoundingBox(bounds);
        this.addStructureData(placementData);
        center = center.offset((int)((double)(-offset.getX()) * 0.5), 0, (int)((double)(-offset.getZ()) * 0.5));
        structure.placeInWorld((ServerLevelAccessor)world, center, center, placementData, random, 4);
        TerrainMerge merge = this.getTerrainMerge(world, center, random);
        int x1 = center.getX();
        int z1 = center.getZ();
        int x2 = x1 + offset.getX();
        int z2 = z1 + offset.getZ();
        if (merge != TerrainMerge.NONE) {
            int a;
            BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
            if (x2 < x1) {
                a = x1;
                x1 = x2;
                x2 = a;
            }
            if (z2 < z1) {
                a = z1;
                z1 = z2;
                z2 = a;
            }
            int surfMax = posY - 1;
            for (int x = x1; x <= x2; ++x) {
                mut.setX(x);
                block1: for (int z = z1; z <= z2; ++z) {
                    mut.setZ(z);
                    mut.setY(surfMax);
                    BlockState state = world.getBlockState((BlockPos)mut);
                    if (this.isTerrain(state) || !state.isFaceSturdy((BlockGetter)world, (BlockPos)mut, Direction.DOWN)) continue;
                    for (int i = 0; i < 10; ++i) {
                        mut.setY(mut.getY() - 1);
                        BlockState stateSt = world.getBlockState((BlockPos)mut);
                        if (!this.isTerrain(stateSt)) {
                            if (merge == TerrainMerge.SURFACE) {
                                boolean isTop = mut.getY() == surfMax && state.isSolid();
                                Holder b = world.getBiome((BlockPos)mut);
                                BlockState top = isTop ? EndBiome.findTopMaterial((Holder<Biome>)b) : EndBiome.findUnderMaterial((Holder<Biome>)b);
                                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)top);
                                continue;
                            }
                            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)state);
                            continue;
                        }
                        if (!this.isTerrain(state) || !state.isSolid()) continue block1;
                        if (merge == TerrainMerge.SURFACE) {
                            Holder b = world.getBiome((BlockPos)mut);
                            BlockState bottom = EndBiome.findUnderMaterial((Holder<Biome>)b);
                            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)bottom);
                            continue block1;
                        }
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)state);
                        continue block1;
                    }
                }
            }
        }
        return true;
    }

    private boolean isTerrain(BlockState state) {
        return state.is(CommonBlockTags.END_STONES) || state.is(CommonBlockTags.NETHER_STONES);
    }

    protected BoundingBox makeBox(BlockPos pos) {
        int sx = (pos.getX() >> 4 << 4) - 16;
        int sz = (pos.getZ() >> 4 << 4) - 16;
        int ex = sx + 47;
        int ez = sz + 47;
        return BoundingBox.fromCorners((Vec3i)new Vec3i(sx, 0, sz), (Vec3i)new Vec3i(ex, 255, ez));
    }

    public static enum TerrainMerge implements StringRepresentable
    {
        NONE,
        SURFACE,
        OBJECT;

        public static final Codec<TerrainMerge> CODEC;

        public static TerrainMerge getFromString(String type) {
            if (type.equals("surface")) {
                return SURFACE;
            }
            if (type.equals("object")) {
                return OBJECT;
            }
            return NONE;
        }

        public String getSerializedName() {
            return this.name();
        }

        static {
            CODEC = StringRepresentable.fromEnum(TerrainMerge::values);
        }
    }
}

