/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.world.features.ScatterFeatureConfig;
import org.betterx.betterend.world.features.UnderwaterPlantScatter;

public class MengerSpongeFeature
extends UnderwaterPlantScatter<ScatterFeatureConfig> {
    private static final Function<BlockState, Boolean> REPLACE = state -> {
        if (state.is(EndBlocks.END_LOTUS_STEM)) {
            return false;
        }
        return !state.getFluidState().isEmpty() || state.canBeReplaced();
    };

    public MengerSpongeFeature() {
        super(ScatterFeatureConfig.CODEC);
    }

    @Override
    public void generate(ScatterFeatureConfig cfg, WorldGenLevel world, RandomSource random, BlockPos blockPos) {
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)blockPos, (Block)EndBlocks.MENGER_SPONGE_WET);
        if (random.nextBoolean()) {
            for (Direction dir : BlocksHelper.DIRECTIONS) {
                BlockPos pos = blockPos.relative(dir);
                if (!REPLACE.apply(world.getBlockState(pos)).booleanValue()) continue;
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (Block)EndBlocks.MENGER_SPONGE_WET);
            }
        }
    }
}

