/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.util.GlobalState;

public abstract class FullHeightScatterFeature
extends DefaultFeature {
    private final int radius;

    public FullHeightScatterFeature(int radius) {
        this.radius = radius;
    }

    public abstract boolean canGenerate(WorldGenLevel var1, RandomSource var2, BlockPos var3, BlockPos var4, float var5);

    public abstract void generate(WorldGenLevel var1, RandomSource var2, BlockPos var3);

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        BlockPos.MutableBlockPos POS = GlobalState.stateForThread().POS;
        RandomSource random = featureConfig.random();
        BlockPos center = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        int maxY = world.getHeight(Heightmap.Types.WORLD_SURFACE_WG, center.getX(), center.getZ());
        int minY = BlocksHelper.upRay((LevelAccessor)world, (BlockPos)new BlockPos(center.getX(), 0, center.getZ()), (int)maxY);
        for (int y = maxY; y > minY; --y) {
            POS.set(center.getX(), y, center.getZ());
            if (!world.getBlockState((BlockPos)POS).isAir() || world.getBlockState(POS.below()).isAir()) continue;
            float r = MHelper.randRange((float)((float)this.radius * 0.5f), (float)this.radius, (RandomSource)random);
            int count = MHelper.floor((double)(r * r * MHelper.randRange((float)1.5f, (float)3.0f, (RandomSource)random)));
            for (int i = 0; i < count; ++i) {
                float pr = r * (float)Math.sqrt(random.nextFloat());
                float theta = random.nextFloat() * ((float)Math.PI * 2);
                float x = pr * (float)Math.cos(theta);
                float z = pr * (float)Math.sin(theta);
                POS.set((double)((float)center.getX() + x), (double)(y + 5), (double)((float)center.getZ() + z));
                int down = BlocksHelper.downRay((LevelAccessor)world, (BlockPos)POS, (int)16);
                if (down > 10) continue;
                POS.setY(POS.getY() - down);
                if (!this.canGenerate(world, random, center, (BlockPos)POS, r)) continue;
                this.generate(world, random, (BlockPos)POS);
            }
        }
        return true;
    }
}

