/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.blocks.BaseDoublePlantBlock;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.world.features.DoublePlantFeatureConfig;
import org.betterx.betterend.world.features.ScatterFeature;

public class DoublePlantFeature
extends ScatterFeature<DoublePlantFeatureConfig> {
    private BlockState plant;

    public DoublePlantFeature() {
        super(DoublePlantFeatureConfig.CODEC);
    }

    @Override
    public boolean canGenerate(DoublePlantFeatureConfig cfg, WorldGenLevel world, RandomSource random, BlockPos center, BlockPos blockPos, float radius) {
        float d = MHelper.length((float)(center.getX() - blockPos.getX()), (float)(center.getZ() - blockPos.getZ())) / radius * 0.6f + random.nextFloat() * 0.4f;
        this.plant = d < 0.5f ? cfg.getLargePlantState(random, blockPos) : cfg.getSmallPlantState(random, blockPos);
        return this.plant.canSurvive((LevelReader)world, blockPos);
    }

    @Override
    public void generate(DoublePlantFeatureConfig cfg, WorldGenLevel world, RandomSource random, BlockPos blockPos) {
        Block block = this.plant.getBlock();
        if (block instanceof BaseDoublePlantBlock) {
            BaseDoublePlantBlock dpb = (BaseDoublePlantBlock)block;
            int rot = random.nextInt(4);
            BlockState state = (BlockState)this.plant.setValue((Property)BaseDoublePlantBlock.ROTATION, (Comparable)Integer.valueOf(rot));
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)blockPos, (BlockState)state);
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)blockPos.above(), (BlockState)((BlockState)state.setValue((Property)BaseDoublePlantBlock.TOP, (Comparable)Boolean.valueOf(true))));
        } else {
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)blockPos, (BlockState)this.plant);
        }
    }
}

