/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.util.MHelper;
import org.betterx.bclib.util.StructureErode;
import org.betterx.bclib.util.StructureHelper;
import org.betterx.betterend.util.BlockFixer;
import org.betterx.betterend.world.features.NBTFeature;
import org.betterx.betterend.world.features.NBTFeatureConfig;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class CrashedShipFeature
extends NBTFeature<NBTFeatureConfig> {
    private static final StructureProcessor REPLACER = new StructureProcessor(){

        public StructureTemplate.StructureBlockInfo processBlock(LevelReader worldView, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfo, StructureTemplate.StructureBlockInfo structureBlockInfo2, StructurePlaceSettings structurePlacementData) {
            BlockState state = structureBlockInfo2.state();
            if (state.is(Blocks.SPAWNER) || state.getSoundType() == SoundType.WOOL) {
                return new StructureTemplate.StructureBlockInfo(structureBlockInfo2.pos(), DefaultFeature.AIR, null);
            }
            return structureBlockInfo2;
        }

        protected StructureProcessorType<?> getType() {
            return StructureProcessorType.NOP;
        }
    };
    private static final String STRUCTURE_PATH = "/data/minecraft/structure/end_city/ship.nbt";
    private StructureTemplate structure;

    public CrashedShipFeature() {
        super(NBTFeatureConfig.CODEC);
    }

    @Override
    protected StructureTemplate getStructure(NBTFeatureConfig cfg, WorldGenLevel world, BlockPos pos, RandomSource random) {
        if (this.structure == null) {
            this.structure = world.getLevel().getStructureManager().getOrCreate(ResourceLocation.withDefaultNamespace((String)"end_city/ship"));
            if (this.structure == null) {
                this.structure = StructureHelper.readStructure((String)STRUCTURE_PATH);
            }
        }
        return this.structure;
    }

    @Override
    protected boolean canSpawn(WorldGenLevel world, BlockPos pos, RandomSource random) {
        long z;
        long x = pos.getX() >> 4;
        if (x * x + (z = (long)(pos.getX() >> 4)) * z < 3600L) {
            return false;
        }
        return pos.getY() > 5 && world.getBlockState(pos.below()).is(CommonBlockTags.END_STONES);
    }

    @Override
    protected Rotation getRotation(WorldGenLevel world, BlockPos pos, RandomSource random) {
        return Rotation.getRandom((RandomSource)random);
    }

    @Override
    protected Mirror getMirror(WorldGenLevel world, BlockPos pos, RandomSource random) {
        return Mirror.values()[random.nextInt(3)];
    }

    @Override
    protected int getYOffset(StructureTemplate structure, WorldGenLevel world, BlockPos pos, RandomSource random) {
        int min = structure.getSize().getY() >> 3;
        int max = structure.getSize().getY() >> 2;
        return -MHelper.randRange((int)min, (int)max, (RandomSource)random);
    }

    @Override
    protected NBTFeature.TerrainMerge getTerrainMerge(WorldGenLevel world, BlockPos pos, RandomSource random) {
        return NBTFeature.TerrainMerge.NONE;
    }

    @Override
    public boolean place(FeaturePlaceContext<NBTFeatureConfig> featureConfig) {
        RandomSource random = featureConfig.random();
        BlockPos center = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        center = new BlockPos(center.getX() >> 4 << 4 | 8, 128, center.getZ() >> 4 << 4 | 8);
        center = this.getGround(world, center);
        BoundingBox bounds = this.makeBox(center);
        if (!this.canSpawn(world, center, random)) {
            return false;
        }
        StructureTemplate structure = this.getStructure((NBTFeatureConfig)featureConfig.config(), world, center, random);
        Rotation rotation = this.getRotation(world, center, random);
        Mirror mirror = this.getMirror(world, center, random);
        BlockPos offset = StructureTemplate.transform((BlockPos)new BlockPos(structure.getSize()), (Mirror)mirror, (Rotation)rotation, (BlockPos)BlockPos.ZERO);
        center = center.offset(0, (int)((double)this.getYOffset(structure, world, center, random) + 0.5), 0);
        StructurePlaceSettings placementData = new StructurePlaceSettings().setRotation(rotation).setMirror(mirror);
        center = center.offset((int)((double)(-offset.getX()) * 0.5), 0, (int)((double)(-offset.getZ()) * 0.5));
        BoundingBox structB = structure.getBoundingBox(placementData, center);
        bounds = StructureHelper.intersectBoxes((BoundingBox)bounds, (BoundingBox)structB);
        this.addStructureData(placementData);
        structure.placeInWorld((ServerLevelAccessor)world, center, center, placementData.setBoundingBox(bounds), random, 2);
        StructureErode.erodeIntense((WorldGenLevel)world, (BoundingBox)bounds, (RandomSource)random);
        BlockFixer.fixBlocks((LevelAccessor)world, new BlockPos(bounds.minX(), bounds.minY(), bounds.minZ()), new BlockPos(bounds.maxX(), bounds.maxY(), bounds.maxZ()));
        return true;
    }

    @Override
    protected void addStructureData(StructurePlaceSettings data) {
        data.addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_AND_AIR).addProcessor(REPLACER).setIgnoreEntities(true);
    }
}

