/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.blocks.basis.EndPlantWithAgeBlock;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.world.features.ScatterFeature;
import org.betterx.betterend.world.features.ScatterFeatureConfig;

public class BlueVineFeature
extends ScatterFeature<ScatterFeatureConfig> {
    private boolean small;

    public BlueVineFeature() {
        super(ScatterFeatureConfig.CODEC);
    }

    @Override
    public boolean canGenerate(ScatterFeatureConfig cfg, WorldGenLevel world, RandomSource random, BlockPos center, BlockPos blockPos, float radius) {
        float d = MHelper.length((float)(center.getX() - blockPos.getX()), (float)(center.getZ() - blockPos.getZ())) / radius * 0.6f + random.nextFloat() * 0.4f;
        this.small = d > 0.5f;
        return EndBlocks.BLUE_VINE_SEED.defaultBlockState().canSurvive((LevelReader)world, blockPos);
    }

    @Override
    public void generate(ScatterFeatureConfig cfg, WorldGenLevel world, RandomSource random, BlockPos blockPos) {
        if (this.small) {
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)blockPos, (BlockState)((BlockState)EndBlocks.BLUE_VINE_SEED.defaultBlockState().setValue((Property)EndPlantWithAgeBlock.AGE, (Comparable)Integer.valueOf(random.nextInt(4)))));
        } else {
            EndPlantWithAgeBlock seed = (EndPlantWithAgeBlock)EndBlocks.BLUE_VINE_SEED;
            seed.growAdult(world, random, blockPos);
        }
    }
}

