/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.biome;

import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.EndPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import org.betterx.bclib.interfaces.SurfaceMaterialProvider;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.registry.EndFeatures;
import org.betterx.betterend.registry.EndSounds;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.biome.EndBiomeKey;
import org.betterx.wover.biome.api.BiomeKey;
import org.betterx.wover.biome.api.builder.BiomeBootstrapContext;
import org.betterx.wover.biome.api.builder.BiomeBuilder;
import org.betterx.wover.biome.api.builder.BiomeSurfaceRuleBuilder;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.biome.api.data.BiomeGenerationDataContainer;
import org.betterx.wover.generator.api.biomesource.WoverBiomeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EndBiomeBuilder
extends WoverBiomeBuilder.AbstractWoverBiomeBuilder<EndBiomeBuilder> {
    protected boolean hasCave = false;
    protected SurfaceMaterialProvider surface = EndBiome.Config.DEFAULT_MATERIAL;
    protected BiomeFactory biomeFactory;

    protected EndBiomeBuilder(BiomeBootstrapContext context, BiomeKey<EndBiomeBuilder> key, TagKey<Biome> ... biomeTag) {
        super(context, key);
        ((EndBiomeBuilder)((EndBiomeBuilder)((EndBiomeBuilder)((EndBiomeBuilder)((EndBiomeBuilder)((EndBiomeBuilder)((EndBiomeBuilder)((EndBiomeBuilder)((EndBiomeBuilder)((EndBiomeBuilder)this.music((Holder)SoundEvents.MUSIC_END)).waterColor(BiomeBuilder.DEFAULT_END_WATER_COLOR)).waterFogColor(BiomeBuilder.DEFAULT_END_WATER_FOG_COLOR)).fogColor(BiomeBuilder.DEFAULT_END_FOG_COLOR)).skyColor(BiomeBuilder.DEFAULT_END_SKY_COLOR)).mood(EndSounds.AMBIENT_DUST_WASTELANDS)).temperature(BiomeBuilder.DEFAULT_END_TEMPERATURE)).downfall(BiomeBuilder.DEFAULT_END_WETNESS)).hasPrecipitation(false)).intendedPlacement(biomeTag.length > 0 ? biomeTag[0] : null)).tag(biomeTag);
    }

    EndBiomeBuilder configure(EndBiome.Config biomeConfig) {
        ((BiomeSurfaceRuleBuilder)this.startSurface().rule(biomeConfig.surfaceMaterial().surface().build())).finishSurface();
        this.surface = biomeConfig.surfaceMaterial();
        this.hasCave = biomeConfig.hasCaves();
        if (biomeConfig.hasReturnGateway()) {
            this.feature(GenerationStep.Decoration.SURFACE_STRUCTURES, EndPlacements.END_GATEWAY_RETURN);
        }
        biomeConfig.addCustomBuildData(this);
        EndFeatures.addDefaultFeatures(this, biomeConfig.hasCaves());
        this.biomeFactory = biomeConfig;
        return this;
    }

    public static <C extends EndBiome.Config> EndBiomeKey<C, ?> createKey(@NotNull String name) {
        return new EndBiomeKey(BetterEnd.C.id(name.replace(' ', '_').toLowerCase()), null);
    }

    public static <C extends EndBiome.Config, PC extends EndBiome.Config> EndBiomeKey<C, PC> createKey(@NotNull String name, @Nullable EndBiomeKey<PC, ?> parentOrNull) {
        return new EndBiomeKey(BetterEnd.C.id(name.replace(' ', '_').toLowerCase()), parentOrNull);
    }

    public void registerBiomeData(BootstrapContext<BiomeData> dataContext) {
        EndBiome biome = this.biomeFactory.instantiateBiome(this.fogDensity, this.key, new BiomeGenerationDataContainer(this.parameters, this.intendedPlacement), this.terrainHeight, this.genChance, this.edgeSize, this.vertical, (ResourceKey<Biome>)this.edge, (ResourceKey<Biome>)this.parent, this.hasCave, this.surface);
        biome.datagenSetup(dataContext);
        dataContext.register(this.key.dataKey, (Object)biome);
    }

    @FunctionalInterface
    public static interface BiomeFactory {
        @NotNull
        public EndBiome instantiateBiome(float var1, BiomeKey<?> var2, @NotNull BiomeGenerationDataContainer var3, float var4, float var5, int var6, boolean var7, @Nullable ResourceKey<Biome> var8, @Nullable ResourceKey<Biome> var9, boolean var10, SurfaceMaterialProvider var11);
    }
}

