/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.biome;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.betterx.bclib.interfaces.SurfaceMaterialProvider;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.world.biome.EndBiomeBuilder;
import org.betterx.wover.biome.api.BiomeKey;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.biome.api.data.BiomeGenerationDataContainer;
import org.betterx.wover.generator.api.biomesource.WoverBiomeData;
import org.betterx.wover.generator.api.biomesource.WoverBiomePicker;
import org.betterx.wover.surface.api.SurfaceRuleBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EndBiome
extends WoverBiomeData
implements SurfaceMaterialProvider {
    public static final MapCodec<EndBiome> CODEC = EndBiome.codec((RecordCodecBuilder)Codec.BOOL.fieldOf("has_caves").orElse((Object)true).forGetter(o -> o.hasCaves), (RecordCodecBuilder)SurfaceMaterialProvider.CODEC.fieldOf("surface").orElse((Object)Config.DEFAULT_MATERIAL).forGetter(o -> o.surfMatProv), EndBiome::new);
    public static final KeyDispatchDataCodec<EndBiome> KEY_CODEC = KeyDispatchDataCodec.of(CODEC);
    private boolean hasCaves = true;
    protected SurfaceMaterialProvider surfMatProv = Config.DEFAULT_MATERIAL;

    public EndBiome(float fogDensity, @NotNull ResourceKey<Biome> biome, @NotNull BiomeGenerationDataContainer generatorData, float terrainHeight, float genChance, int edgeSize, boolean vertical, @Nullable ResourceKey<Biome> edge, @Nullable ResourceKey<Biome> parent, boolean hasCaves, SurfaceMaterialProvider surface) {
        super(fogDensity, biome, generatorData, terrainHeight, genChance, edgeSize, vertical, edge, parent);
        this.hasCaves = hasCaves;
        this.surfMatProv = surface;
    }

    public void datagenSetup(BootstrapContext<BiomeData> dataContext) {
    }

    public KeyDispatchDataCodec<? extends WoverBiomeData> codec() {
        return KEY_CODEC;
    }

    void setHasCaves(boolean v) {
        this.hasCaves = v;
    }

    public boolean hasCaves() {
        return this.hasCaves;
    }

    public BlockState getTopMaterial() {
        return this.surfMatProv.getTopMaterial();
    }

    public BlockState getUnderMaterial() {
        return this.surfMatProv.getUnderMaterial();
    }

    public BlockState getAltTopMaterial() {
        return this.surfMatProv.getAltTopMaterial();
    }

    public boolean generateFloorRule() {
        return this.surfMatProv.generateFloorRule();
    }

    public SurfaceRuleBuilder surface() {
        return this.surfMatProv.surface();
    }

    public static BlockState findTopMaterial(Holder<Biome> biome) {
        return SurfaceMaterialProvider.findSurfaceMaterialProvider(biome).map(SurfaceMaterialProvider::getTopMaterial).orElse(Config.DEFAULT_MATERIAL.getTopMaterial());
    }

    public static BlockState findTopMaterial(WorldGenLevel world, BlockPos pos) {
        return SurfaceMaterialProvider.findSurfaceMaterialProvider((Holder)WoverBiomePicker.getBiomeAt((WorldGenLevel)world, (BlockPos)pos)).map(SurfaceMaterialProvider::getTopMaterial).orElse(Config.DEFAULT_MATERIAL.getTopMaterial());
    }

    public static BlockState findUnderMaterial(Holder<Biome> biome) {
        return SurfaceMaterialProvider.findSurfaceMaterialProvider(biome).map(SurfaceMaterialProvider::getUnderMaterial).orElse(Config.DEFAULT_MATERIAL.getUnderMaterial());
    }

    public static BlockState findUnderMaterial(WorldGenLevel world, BlockPos pos) {
        return SurfaceMaterialProvider.findSurfaceMaterialProvider((WorldGenLevel)world, (BlockPos)pos).map(SurfaceMaterialProvider::getUnderMaterial).orElse(Config.DEFAULT_MATERIAL.getUnderMaterial());
    }

    public static abstract class Config
    implements EndBiomeBuilder.BiomeFactory {
        public static final SurfaceMaterialProvider DEFAULT_MATERIAL = new DefaultSurfaceMaterialProvider();
        protected static final SurfaceRules.RuleSource END_STONE = SurfaceRules.state((BlockState)DefaultSurfaceMaterialProvider.END_STONE);
        protected static final SurfaceRules.RuleSource END_MOSS = SurfaceRules.state((BlockState)EndBlocks.END_MOSS.defaultBlockState());
        protected static final SurfaceRules.RuleSource ENDSTONE_DUST = SurfaceRules.state((BlockState)EndBlocks.ENDSTONE_DUST.defaultBlockState());
        protected static final SurfaceRules.RuleSource END_MYCELIUM = SurfaceRules.state((BlockState)EndBlocks.END_MYCELIUM.defaultBlockState());
        protected static final SurfaceRules.RuleSource FLAVOLITE = SurfaceRules.state((BlockState)EndBlocks.FLAVOLITE.stone.defaultBlockState());
        protected static final SurfaceRules.RuleSource SULPHURIC_ROCK = SurfaceRules.state((BlockState)EndBlocks.SULPHURIC_ROCK.stone.defaultBlockState());
        protected static final SurfaceRules.RuleSource BRIMSTONE = SurfaceRules.state((BlockState)EndBlocks.BRIMSTONE.defaultBlockState());
        protected static final SurfaceRules.RuleSource PALLIDIUM_FULL = SurfaceRules.state((BlockState)EndBlocks.PALLIDIUM_FULL.defaultBlockState());
        protected static final SurfaceRules.RuleSource PALLIDIUM_HEAVY = SurfaceRules.state((BlockState)EndBlocks.PALLIDIUM_HEAVY.defaultBlockState());
        protected static final SurfaceRules.RuleSource PALLIDIUM_THIN = SurfaceRules.state((BlockState)EndBlocks.PALLIDIUM_THIN.defaultBlockState());
        protected static final SurfaceRules.RuleSource PALLIDIUM_TINY = SurfaceRules.state((BlockState)EndBlocks.PALLIDIUM_TINY.defaultBlockState());
        protected static final SurfaceRules.RuleSource UMBRALITH = SurfaceRules.state((BlockState)EndBlocks.UMBRALITH.stone.defaultBlockState());

        protected Config() {
        }

        public abstract void addCustomBuildData(EndBiomeBuilder var1);

        public boolean hasCaves() {
            return true;
        }

        public boolean hasReturnGateway() {
            return true;
        }

        public SurfaceMaterialProvider surfaceMaterial() {
            return DEFAULT_MATERIAL;
        }

        @Override
        @NotNull
        public EndBiome instantiateBiome(float fogDensity, BiomeKey<?> key, @NotNull BiomeGenerationDataContainer generatorData, float terrainHeight, float genChance, int edgeSize, boolean vertical, @Nullable ResourceKey<Biome> edge, @Nullable ResourceKey<Biome> parent, boolean hasCave, SurfaceMaterialProvider surface) {
            return new EndBiome(fogDensity, (ResourceKey<Biome>)key.key, generatorData, terrainHeight, genChance, edgeSize, vertical, edge, parent, hasCave, surface);
        }
    }

    public static class DefaultSurfaceMaterialProvider
    implements SurfaceMaterialProvider {
        public static final BlockState END_STONE = Blocks.END_STONE.defaultBlockState();

        public BlockState getTopMaterial() {
            return this.getUnderMaterial();
        }

        public BlockState getAltTopMaterial() {
            return this.getTopMaterial();
        }

        public BlockState getUnderMaterial() {
            return END_STONE;
        }

        public boolean generateFloorRule() {
            return true;
        }

        public SurfaceRuleBuilder surface() {
            SurfaceRuleBuilder builder = SurfaceRuleBuilder.start();
            if (this.generateFloorRule() && this.getTopMaterial() != this.getUnderMaterial()) {
                if (this.getTopMaterial() != this.getAltTopMaterial()) {
                    builder.floor(this.getTopMaterial());
                } else {
                    builder.chancedFloor(this.getTopMaterial(), this.getAltTopMaterial());
                }
            }
            return (SurfaceRuleBuilder)builder.filler(this.getUnderMaterial());
        }
    }
}

