/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.util;

import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.registry.EndBiomes;
import org.betterx.betterend.registry.EndItems;
import org.betterx.betterend.registry.EndTemplates;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.loot.api.LootTableManager;

public class LootTableUtil {
    public static final ResourceKey<LootTable> VILLAGE_LOOT = LootTableManager.createLootTableKey((ModCore)BetterEnd.C, (String)"chests/end_village_loot");
    public static final ResourceKey<LootTable> VILLAGE_TEMPLATE_LOOT = LootTableManager.createLootTableKey((ModCore)BetterEnd.C, (String)"chests/end_village_template_loot");
    public static final ResourceKey<LootTable> VILLAGE_BONUS_LOOT = LootTableManager.createLootTableKey((ModCore)BetterEnd.C, (String)"chests/end_village_bonus_loot");
    public static final ResourceKey<LootTable> COMMON = LootTableManager.createLootTableKey((ModCore)BetterEnd.C, (String)"chests/common");
    public static final ResourceKey<LootTable> FOGGY_MUSHROOMLAND = LootTableManager.createLootTableKey((ModCore)BetterEnd.C, (String)"chests/foggy_mushroomland");
    public static final ResourceKey<LootTable> CHORUS_FOREST = LootTableManager.createLootTableKey((ModCore)BetterEnd.C, (String)"chests/chorus_forest");
    public static final ResourceKey<LootTable> SHADOW_FOREST = LootTableManager.createLootTableKey((ModCore)BetterEnd.C, (String)"chests/shadow_forest");
    public static final ResourceKey<LootTable> LANTERN_WOODS = LootTableManager.createLootTableKey((ModCore)BetterEnd.C, (String)"chests/lantern_woods");
    public static final ResourceKey<LootTable> UMBRELLA_JUNGLE = LootTableManager.createLootTableKey((ModCore)BetterEnd.C, (String)"chests/umbrella_jungle");
    public static final ResourceKey<LootTable> BIOME_CHEST = LootTableManager.createLootTableKey((ModCore)BetterEnd.C, (String)"chests/biome");
    public static final ResourceKey<LootTable> FISHING_FISH = LootTableManager.createLootTableKey((ModCore)BetterEnd.C, (String)"gameplay/fishing/fish");
    public static final ResourceKey<LootTable> FISHING_TREASURE = LootTableManager.createLootTableKey((ModCore)BetterEnd.C, (String)"gameplay/fishing/treasure");
    public static final ResourceKey<LootTable> FISHING_JUNK = LootTableManager.createLootTableKey((ModCore)BetterEnd.C, (String)"gameplay/fishing/junk");

    public static void init() {
        LootTableEvents.MODIFY.register((key, tableBuilder, source) -> {
            ResourceLocation id = key.location();
            LootItemCondition.Builder IN_END = LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setDimension(Level.END));
            if (BuiltInLootTables.END_CITY_TREASURE.equals(id)) {
                LootPool.Builder builder = LootPool.lootPool();
                builder.setRolls((NumberProvider)ConstantValue.exactly((float)1.0f));
                builder.when(LootItemRandomChanceCondition.randomChance((float)0.2f));
                builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GHAST_TEAR));
                tableBuilder.withPool(builder);
                builder = LootPool.lootPool();
                builder.setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)3.0f));
                builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndItems.MUSIC_DISC_STRANGE_AND_ALIEN));
                builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndItems.MUSIC_DISC_GRASPING_AT_STARS));
                builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndItems.MUSIC_DISC_ENDSEEKER));
                builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndItems.MUSIC_DISC_EO_DRACONA));
                tableBuilder.withPool(builder);
                tableBuilder.withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(12)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndTemplates.NETHERITE_UPGRADE).setWeight(3)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndTemplates.HANDLE_ATTACHMENT).setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndTemplates.LEATHER_HANDLE_ATTACHMENT).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndTemplates.TOOL_ASSEMBLY).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndTemplates.AETERNIUM_UPGRADE).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndTemplates.THALLASIUM_UPGRADE).setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndTemplates.TERMINITE_UPGRADE).setWeight(2)));
            } else if (BuiltInLootTables.FISHING.equals(id)) {
                tableBuilder.modifyPools(modifier -> modifier.when(IN_END.invert()));
                tableBuilder.withPool(LootPool.lootPool().when(IN_END).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference(FISHING_FISH).setWeight(85).setQuality(-1)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference(FISHING_TREASURE).setWeight(5).setQuality(2)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference(FISHING_JUNK).setWeight(10).setQuality(-2)));
            }
        });
    }

    public static ResourceKey<LootTable> getTable(Holder<Biome> biome) {
        if (biome.unwrapKey().isPresent()) {
            if (biome.is(EndBiomes.FOGGY_MUSHROOMLAND.key)) {
                return FOGGY_MUSHROOMLAND;
            }
            if (biome.is(EndBiomes.CHORUS_FOREST.key)) {
                return CHORUS_FOREST;
            }
            if (biome.is(EndBiomes.SHADOW_FOREST.key)) {
                return SHADOW_FOREST;
            }
            if (biome.is(EndBiomes.LANTERN_WOODS.key)) {
                return LANTERN_WOODS;
            }
            if (biome.is(EndBiomes.UMBRELLA_JUNGLE.key)) {
                return UMBRELLA_JUNGLE;
            }
        }
        return COMMON;
    }
}

