/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.registry;

import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.items.BaseArmorItem;
import org.betterx.bclib.items.BaseDiscItem;
import org.betterx.bclib.items.BaseSpawnEggItem;
import org.betterx.bclib.items.ModelProviderItem;
import org.betterx.bclib.items.tool.BaseAxeItem;
import org.betterx.bclib.items.tool.BaseHoeItem;
import org.betterx.bclib.items.tool.BaseShovelItem;
import org.betterx.bclib.items.tool.BaseSwordItem;
import org.betterx.bclib.models.RecordItemModelProvider;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.item.ArmoredElytra;
import org.betterx.betterend.item.CrystaliteBoots;
import org.betterx.betterend.item.CrystaliteChestplate;
import org.betterx.betterend.item.CrystaliteElytra;
import org.betterx.betterend.item.CrystaliteHelmet;
import org.betterx.betterend.item.CrystaliteLeggings;
import org.betterx.betterend.item.EnchantedItem;
import org.betterx.betterend.item.EndBucketItem;
import org.betterx.betterend.item.EternalCrystalItem;
import org.betterx.betterend.item.GuideBookItem;
import org.betterx.betterend.item.material.EndArmorMaterial;
import org.betterx.betterend.item.material.EndArmorTier;
import org.betterx.betterend.item.material.EndToolMaterial;
import org.betterx.betterend.item.tool.EndHammerItem;
import org.betterx.betterend.item.tool.EndPickaxe;
import org.betterx.betterend.registry.EndEntities;
import org.betterx.betterend.registry.EndSounds;
import org.betterx.betterend.util.DebugHelpers;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.item.api.ItemRegistry;
import org.betterx.wover.tag.api.predefined.CommonItemTags;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class EndItems {
    private static ItemRegistry ITEMS_REGISTRY;
    public static final Item ENDER_DUST;
    public static final Item ENDER_SHARD;
    public static final Item AETERNIUM_INGOT;
    public static final Item AETERNIUM_FORGED_PLATE;
    public static final Item END_LILY_LEAF;
    public static final Item END_LILY_LEAF_DRIED;
    public static final Item CRYSTAL_SHARDS;
    public static final Item RAW_AMBER;
    public static final Item AMBER_GEM;
    public static final Item GLOWING_BULB;
    public static final Item CRYSTALLINE_SULPHUR;
    public static final Item HYDRALUX_PETAL;
    public static final Item GELATINE;
    public static final Item ETERNAL_CRYSTAL;
    public static final Item ENCHANTED_PETAL;
    public static final Item LEATHER_STRIPE;
    public static final Item LEATHER_WRAPPED_STICK;
    public static final Item SILK_FIBER;
    public static final Item LUMECORN_ROD;
    public static final Item SILK_MOTH_MATRIX;
    public static final Item ENCHANTED_MEMBRANE;
    public static final Item MUSIC_DISC_STRANGE_AND_ALIEN;
    public static final Item MUSIC_DISC_GRASPING_AT_STARS;
    public static final Item MUSIC_DISC_ENDSEEKER;
    public static final Item MUSIC_DISC_EO_DRACONA;
    public static final Item AETERNIUM_HELMET;
    public static final Item AETERNIUM_CHESTPLATE;
    public static final Item AETERNIUM_LEGGINGS;
    public static final Item AETERNIUM_BOOTS;
    public static final Item CRYSTALITE_HELMET;
    public static final Item CRYSTALITE_CHESTPLATE;
    public static final Item CRYSTALITE_LEGGINGS;
    public static final Item CRYSTALITE_BOOTS;
    public static final Item ARMORED_ELYTRA;
    public static final Item CRYSTALITE_ELYTRA;
    public static final TieredItem AETERNIUM_SHOVEL;
    public static final TieredItem AETERNIUM_SWORD;
    public static final TieredItem AETERNIUM_PICKAXE;
    public static final TieredItem AETERNIUM_AXE;
    public static final TieredItem AETERNIUM_HOE;
    public static final TieredItem AETERNIUM_HAMMER;
    public static final Item AETERNIUM_SHOVEL_HEAD;
    public static final Item AETERNIUM_PICKAXE_HEAD;
    public static final Item AETERNIUM_AXE_HEAD;
    public static final Item AETERNIUM_HOE_HEAD;
    public static final Item AETERNIUM_HAMMER_HEAD;
    public static final Item AETERNIUM_SWORD_BLADE;
    public static final Item AETERNIUM_SWORD_HANDLE;
    public static final TieredItem IRON_HAMMER;
    public static final TieredItem GOLDEN_HAMMER;
    public static final TieredItem DIAMOND_HAMMER;
    public static final TieredItem NETHERITE_HAMMER;
    public static final Item SHADOW_BERRY_RAW;
    public static final Item SHADOW_BERRY_COOKED;
    public static final Item END_FISH_RAW;
    public static final Item END_FISH_COOKED;
    public static final Item BUCKET_END_FISH;
    public static final Item BUCKET_CUBOZOA;
    public static final Item SWEET_BERRY_JELLY;
    public static final Item SHADOW_BERRY_JELLY;
    public static final Item BLOSSOM_BERRY_JELLY;
    public static final Item BLOSSOM_BERRY;
    public static final Item AMBER_ROOT_RAW;
    public static final Item CHORUS_MUSHROOM_RAW;
    public static final Item CHORUS_MUSHROOM_COOKED;
    public static final Item BOLUX_MUSHROOM_COOKED;
    public static final Item CAVE_PUMPKIN_PIE;
    public static final Item UMBRELLA_CLUSTER_JUICE;

    public static List<Item> getModItems() {
        return EndItems.getItemRegistry().allItems().toList();
    }

    public static Item registerEndDisc(String name, ResourceKey<JukeboxSong> sound) {
        Item item = BaseDiscItem.create(sound, (Item.Properties)BehaviourBuilders.createDisc());
        RecordItemModelProvider.add((Item)item);
        EndItems.getItemRegistry().register(name, item, new TagKey[]{CommonItemTags.MUSIC_DISCS});
        return item;
    }

    public static Item registerEndItem(String name) {
        return EndItems.getItemRegistry().register(name, (Item)new ModelProviderItem(EndItems.makeEndItemSettings()), new TagKey[0]);
    }

    public static Item registerEndItem(String name, Item item) {
        return EndItems.getItemRegistry().register(name, item, new TagKey[0]);
    }

    public static TieredItem registerEndTool(String name, TieredItem item) {
        return (TieredItem)EndItems.getItemRegistry().registerAsTool(name, (Item)item, new TagKey[0]);
    }

    public static Item registerEndEgg(String name, EntityType<? extends Mob> type, int background, int dots) {
        return EndItems.getItemRegistry().registerEgg(name, (SpawnEggItem)new BaseSpawnEggItem(type, background, dots, EndItems.makeEndItemSettings()), new TagKey[0]);
    }

    public static Item registerEndFood(String name, int hunger, float saturation, MobEffectInstance ... effects) {
        return EndItems.getItemRegistry().registerFood(name, ModelProviderItem::new, hunger, saturation, effects);
    }

    public static Item registerEndFood(String name, FoodProperties foodComponent) {
        return EndItems.getItemRegistry().register(name, (Item)new ModelProviderItem(EndItems.getItemRegistry().createDefaultItemSettings().food(foodComponent)), new TagKey[0]);
    }

    public static Item registerEndDrink(String name, int hunger, float saturation) {
        return EndItems.getItemRegistry().registerDrink(name, ModelProviderItem::new, hunger, saturation, new MobEffectInstance[0]);
    }

    public static Item.Properties makeEndItemSettings() {
        return new Item.Properties();
    }

    @NotNull
    public static ItemRegistry getItemRegistry() {
        if (ITEMS_REGISTRY == null) {
            ITEMS_REGISTRY = ItemRegistry.forMod((ModCore)BetterEnd.C);
        }
        return ITEMS_REGISTRY;
    }

    @ApiStatus.Internal
    public static void ensureStaticallyLoaded() {
        GuideBookItem.ensureStaticallyLoaded();
        if (BCLib.isDevEnvironment()) {
            DebugHelpers.generateDebugItems();
        }
    }

    public static Item.Properties defaultSettings() {
        return new Item.Properties();
    }

    static {
        ENDER_DUST = EndItems.registerEndItem("ender_dust");
        ENDER_SHARD = EndItems.registerEndItem("ender_shard");
        AETERNIUM_INGOT = EndItems.registerEndItem("aeternium_ingot", (Item)new ModelProviderItem(EndItems.makeEndItemSettings().fireResistant()));
        AETERNIUM_FORGED_PLATE = EndItems.registerEndItem("aeternium_forged_plate", (Item)new ModelProviderItem(EndItems.makeEndItemSettings().fireResistant()));
        END_LILY_LEAF = EndItems.registerEndItem("end_lily_leaf");
        END_LILY_LEAF_DRIED = EndItems.registerEndItem("end_lily_leaf_dried");
        CRYSTAL_SHARDS = EndItems.registerEndItem("crystal_shards");
        RAW_AMBER = EndItems.registerEndItem("raw_amber");
        AMBER_GEM = EndItems.registerEndItem("amber_gem");
        GLOWING_BULB = EndItems.registerEndItem("glowing_bulb");
        CRYSTALLINE_SULPHUR = EndItems.registerEndItem("crystalline_sulphur");
        HYDRALUX_PETAL = EndItems.registerEndItem("hydralux_petal");
        GELATINE = EndItems.registerEndItem("gelatine");
        ETERNAL_CRYSTAL = EndItems.registerEndItem("eternal_crystal", (Item)new EternalCrystalItem());
        ENCHANTED_PETAL = EndItems.registerEndItem("enchanted_petal", (Item)new EnchantedItem(HYDRALUX_PETAL));
        LEATHER_STRIPE = EndItems.registerEndItem("leather_stripe");
        LEATHER_WRAPPED_STICK = EndItems.registerEndItem("leather_wrapped_stick");
        SILK_FIBER = EndItems.registerEndItem("silk_fiber");
        LUMECORN_ROD = EndItems.registerEndItem("lumecorn_rod");
        SILK_MOTH_MATRIX = EndItems.registerEndItem("silk_moth_matrix");
        ENCHANTED_MEMBRANE = EndItems.registerEndItem("enchanted_membrane", (Item)new EnchantedItem(Items.PHANTOM_MEMBRANE));
        MUSIC_DISC_STRANGE_AND_ALIEN = EndItems.registerEndDisc("music_disc_strange_and_alien", EndSounds.RECORD_STRANGE_AND_ALIEN);
        MUSIC_DISC_GRASPING_AT_STARS = EndItems.registerEndDisc("music_disc_grasping_at_stars", EndSounds.RECORD_GRASPING_AT_STARS);
        MUSIC_DISC_ENDSEEKER = EndItems.registerEndDisc("music_disc_endseeker", EndSounds.RECORD_ENDSEEKER);
        MUSIC_DISC_EO_DRACONA = EndItems.registerEndDisc("music_disc_eo_dracona", EndSounds.RECORD_EO_DRACONA);
        AETERNIUM_HELMET = EndItems.registerEndItem("aeternium_helmet", (Item)new BaseArmorItem(EndArmorMaterial.AETERNIUM, ArmorItem.Type.HELMET, EndItems.makeEndItemSettings().fireResistant()));
        AETERNIUM_CHESTPLATE = EndItems.registerEndItem("aeternium_chestplate", (Item)new BaseArmorItem(EndArmorMaterial.AETERNIUM, ArmorItem.Type.CHESTPLATE, EndItems.makeEndItemSettings().fireResistant()));
        AETERNIUM_LEGGINGS = EndItems.registerEndItem("aeternium_leggings", (Item)new BaseArmorItem(EndArmorMaterial.AETERNIUM, ArmorItem.Type.LEGGINGS, EndItems.makeEndItemSettings().fireResistant()));
        AETERNIUM_BOOTS = EndItems.registerEndItem("aeternium_boots", (Item)new BaseArmorItem(EndArmorMaterial.AETERNIUM, ArmorItem.Type.BOOTS, EndItems.makeEndItemSettings().fireResistant()));
        CRYSTALITE_HELMET = EndItems.registerEndItem("crystalite_helmet", (Item)new CrystaliteHelmet());
        CRYSTALITE_CHESTPLATE = EndItems.registerEndItem("crystalite_chestplate", (Item)new CrystaliteChestplate());
        CRYSTALITE_LEGGINGS = EndItems.registerEndItem("crystalite_leggings", (Item)new CrystaliteLeggings());
        CRYSTALITE_BOOTS = EndItems.registerEndItem("crystalite_boots", (Item)new CrystaliteBoots());
        ARMORED_ELYTRA = EndItems.registerEndItem("elytra_armored", (Item)new ArmoredElytra("elytra_armored", EndArmorTier.AETERNIUM, Items.PHANTOM_MEMBRANE, 900, 0.97, 1.15f, 1.15f, true));
        CRYSTALITE_ELYTRA = EndItems.registerEndItem("elytra_crystalite", (Item)new CrystaliteElytra(650, 1.0));
        AETERNIUM_SHOVEL = EndItems.registerEndTool("aeternium_shovel", (TieredItem)new BaseShovelItem((Tier)EndToolMaterial.AETERNIUM, 1.5f, -3.0f, EndItems.makeEndItemSettings().fireResistant()));
        AETERNIUM_SWORD = EndItems.registerEndTool("aeternium_sword", (TieredItem)new BaseSwordItem((Tier)EndToolMaterial.AETERNIUM, 3, -2.4f, EndItems.makeEndItemSettings().fireResistant()));
        AETERNIUM_PICKAXE = EndItems.registerEndTool("aeternium_pickaxe", (TieredItem)new EndPickaxe(EndToolMaterial.AETERNIUM, 1, -2.8f, EndItems.makeEndItemSettings().fireResistant()));
        AETERNIUM_AXE = EndItems.registerEndTool("aeternium_axe", (TieredItem)new BaseAxeItem((Tier)EndToolMaterial.AETERNIUM, 5.0f, -3.0f, EndItems.makeEndItemSettings().fireResistant()));
        AETERNIUM_HOE = EndItems.registerEndTool("aeternium_hoe", (TieredItem)new BaseHoeItem((Tier)EndToolMaterial.AETERNIUM, -3, 0.0f, EndItems.makeEndItemSettings().fireResistant()));
        AETERNIUM_HAMMER = EndItems.registerEndTool("aeternium_hammer", (TieredItem)new EndHammerItem(EndToolMaterial.AETERNIUM, 6.0f, -3.0f, 0.3f, EndItems.makeEndItemSettings().fireResistant()));
        AETERNIUM_SHOVEL_HEAD = EndItems.registerEndItem("aeternium_shovel_head", (Item)new ModelProviderItem(EndItems.makeEndItemSettings().fireResistant()));
        AETERNIUM_PICKAXE_HEAD = EndItems.registerEndItem("aeternium_pickaxe_head", (Item)new ModelProviderItem(EndItems.makeEndItemSettings().fireResistant()));
        AETERNIUM_AXE_HEAD = EndItems.registerEndItem("aeternium_axe_head", (Item)new ModelProviderItem(EndItems.makeEndItemSettings().fireResistant()));
        AETERNIUM_HOE_HEAD = EndItems.registerEndItem("aeternium_hoe_head", (Item)new ModelProviderItem(EndItems.makeEndItemSettings().fireResistant()));
        AETERNIUM_HAMMER_HEAD = EndItems.registerEndItem("aeternium_hammer_head", (Item)new ModelProviderItem(EndItems.makeEndItemSettings().fireResistant()));
        AETERNIUM_SWORD_BLADE = EndItems.registerEndItem("aeternium_sword_blade", (Item)new ModelProviderItem(EndItems.makeEndItemSettings().fireResistant()));
        AETERNIUM_SWORD_HANDLE = EndItems.registerEndItem("aeternium_sword_handle", (Item)new ModelProviderItem(EndItems.makeEndItemSettings().fireResistant()));
        IRON_HAMMER = EndItems.registerEndTool("iron_hammer", (TieredItem)new EndHammerItem((Tier)Tiers.IRON, 5.0f, -3.2f, 0.2f, EndItems.makeEndItemSettings()));
        GOLDEN_HAMMER = EndItems.registerEndTool("golden_hammer", (TieredItem)new EndHammerItem((Tier)Tiers.GOLD, 4.5f, -3.4f, 0.3f, EndItems.makeEndItemSettings()));
        DIAMOND_HAMMER = EndItems.registerEndTool("diamond_hammer", (TieredItem)new EndHammerItem((Tier)Tiers.DIAMOND, 5.5f, -3.1f, 0.2f, EndItems.makeEndItemSettings()));
        NETHERITE_HAMMER = EndItems.registerEndTool("netherite_hammer", (TieredItem)new EndHammerItem((Tier)Tiers.NETHERITE, 5.0f, -3.0f, 0.2f, EndItems.makeEndItemSettings().fireResistant()));
        SHADOW_BERRY_RAW = EndItems.registerEndFood("shadow_berry_raw", 4, 0.5f, new MobEffectInstance[0]);
        SHADOW_BERRY_COOKED = EndItems.registerEndFood("shadow_berry_cooked", 6, 0.7f, new MobEffectInstance[0]);
        END_FISH_RAW = EndItems.registerEndFood("end_fish_raw", Foods.SALMON);
        END_FISH_COOKED = EndItems.registerEndFood("end_fish_cooked", Foods.COOKED_SALMON);
        BUCKET_END_FISH = EndItems.registerEndItem("bucket_end_fish", (Item)new EndBucketItem(EndEntities.END_FISH.type()));
        BUCKET_CUBOZOA = EndItems.registerEndItem("bucket_cubozoa", (Item)new EndBucketItem(EndEntities.CUBOZOA.type()));
        SWEET_BERRY_JELLY = EndItems.registerEndFood("sweet_berry_jelly", 8, 0.7f, new MobEffectInstance[0]);
        SHADOW_BERRY_JELLY = EndItems.registerEndFood("shadow_berry_jelly", 6, 0.8f, new MobEffectInstance(MobEffects.NIGHT_VISION, 400));
        BLOSSOM_BERRY_JELLY = EndItems.registerEndFood("blossom_berry_jelly", 8, 0.7f, new MobEffectInstance[0]);
        BLOSSOM_BERRY = EndItems.registerEndFood("blossom_berry", Foods.APPLE);
        AMBER_ROOT_RAW = EndItems.registerEndFood("amber_root_raw", 2, 0.8f, new MobEffectInstance[0]);
        CHORUS_MUSHROOM_RAW = EndItems.registerEndFood("chorus_mushroom_raw", 3, 0.5f, new MobEffectInstance[0]);
        CHORUS_MUSHROOM_COOKED = EndItems.registerEndFood("chorus_mushroom_cooked", Foods.MUSHROOM_STEW);
        BOLUX_MUSHROOM_COOKED = EndItems.registerEndFood("bolux_mushroom_cooked", Foods.MUSHROOM_STEW);
        CAVE_PUMPKIN_PIE = EndItems.registerEndFood("cave_pumpkin_pie", Foods.PUMPKIN_PIE);
        UMBRELLA_CLUSTER_JUICE = EndItems.registerEndDrink("umbrella_cluster_juice", 5, 0.7f);
    }
}

