/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.particle;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.betterx.bclib.util.MHelper;

@Environment(value=EnvType.CLIENT)
public class ParticleBlackSpore
extends SimpleAnimatedParticle {
    private double preVX;
    private double preVY;
    private double preVZ;
    private double nextVX;
    private double nextVY;
    private double nextVZ;

    protected ParticleBlackSpore(ClientLevel world, double x, double y, double z, double r, double g, double b, SpriteSet sprites) {
        super(world, x, y, z, sprites, 0.0f);
        this.setSprite(sprites.get(this.random));
        this.lifetime = MHelper.randRange((int)30, (int)60, (RandomSource)this.random);
        this.quadSize = MHelper.randRange((float)0.05f, (float)0.15f, (RandomSource)this.random);
        this.setColor(1.0f, 1.0f, 1.0f);
        this.setAlpha(0.0f);
        this.preVX = this.random.nextGaussian() * 0.015;
        this.preVY = 0.0;
        this.preVZ = this.random.nextGaussian() * 0.015;
        this.nextVX = this.random.nextGaussian() * 0.015;
        this.nextVY = (double)this.random.nextFloat() * 0.02 + 0.01;
        this.nextVZ = this.random.nextGaussian() * 0.015;
    }

    public void tick() {
        int ticks = this.age & 0xF;
        if (ticks == 0) {
            this.preVX = this.nextVX;
            this.preVY = this.nextVY;
            this.preVZ = this.nextVZ;
            this.nextVX = this.random.nextGaussian() * 0.015;
            this.nextVY = (double)this.random.nextFloat() * 0.02 + 0.01;
            this.nextVZ = this.random.nextGaussian() * 0.015;
        }
        double delta = (double)ticks / 15.0;
        if (this.age <= 15) {
            this.setAlpha((float)this.age / 15.0f);
        } else if (this.age >= this.lifetime - 15) {
            this.setAlpha((float)(this.lifetime - this.age) / 15.0f);
        }
        if (this.age >= this.lifetime) {
            this.remove();
        }
        this.xd = Mth.lerp((double)delta, (double)this.preVX, (double)this.nextVX);
        this.yd = Mth.lerp((double)delta, (double)this.preVY, (double)this.nextVY);
        this.zd = Mth.lerp((double)delta, (double)this.preVZ, (double)this.nextVZ);
        super.tick();
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @Environment(value=EnvType.CLIENT)
    public static class FactoryBlackSpore
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public FactoryBlackSpore(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double vX, double vY, double vZ) {
            return new ParticleBlackSpore(world, x, y, z, 1.0, 1.0, 1.0, this.sprites);
        }
    }
}

