/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.network;

import de.ambertation.wunderlib.network.ClientBoundNetworkPayload;
import de.ambertation.wunderlib.network.ClientBoundPacketHandler;
import de.ambertation.wunderlib.network.PacketHandler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.betterx.bclib.api.v2.dataexchange.BaseDataHandler;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.rituals.EternalRitual;

public class RitualUpdate
extends ClientBoundPacketHandler<Payload> {
    public static final ResourceLocation CHANNEL = BetterEnd.C.mk("ritual_update");
    public static final RitualUpdate INSTANCE = new RitualUpdate();
    Payload payload;
    private static final byte ACTIVE_FLAG = 1;
    private static final byte WILL_ACTIVATE_FLAG = 2;

    public RitualUpdate() {
        super(CHANNEL, Payload::new);
    }

    public RitualUpdate(EternalRitual ritual) {
        this();
        this.payload = new Payload(ritual);
    }

    public void sendToClient(ServerLevel level) {
        ClientBoundPacketHandler.sendToClient((ServerLevel)level, (ClientBoundNetworkPayload)this.payload);
    }

    public static class Payload
    extends ClientBoundNetworkPayload<Payload> {
        byte flags;
        BlockPos center;
        Direction.Axis axis;

        public Payload(EternalRitual ritual) {
            super((PacketHandler)INSTANCE);
            this.center = ritual.getCenter();
            this.axis = ritual.getAxis();
            if (ritual.isActive()) {
                this.flags = (byte)(this.flags | 1);
            }
            if (ritual.willActivate()) {
                this.flags = (byte)(this.flags | 2);
            }
        }

        public Payload(FriendlyByteBuf buf) {
            super((PacketHandler)INSTANCE);
            this.center = buf.readBlockPos();
            this.axis = Direction.Axis.byName((String)BaseDataHandler.readString((FriendlyByteBuf)buf));
            this.flags = buf.readByte();
        }

        protected void write(FriendlyByteBuf buf) {
            buf.writeBlockPos(this.center);
            BaseDataHandler.writeString((FriendlyByteBuf)buf, (String)this.axis.getName());
            buf.writeByte((int)this.flags);
        }

        protected void prepareOnServer(ServerPlayer player) {
        }

        protected void processOnClient(PacketSender responseSender) {
        }

        @Environment(value=EnvType.CLIENT)
        protected void processOnGameThread(Minecraft client) {
            EternalRitual.updateActiveStateOnPedestals(this.center, this.axis, (this.flags & 1) != 0, (this.flags & 2) != 0, (Level)client.level, null);
        }
    }
}

