/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.mixin.common;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.betterx.bclib.util.StructureHelper;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.world.generator.GeneratorOptions;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.state.api.WorldConfig;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EndPodiumFeature.class})
public class EndPodiumFeatureMixin {
    @Unique
    private static BlockPos be_portalPosition;
    @Final
    @Shadow
    private boolean active;

    @Inject(method={"place"}, at={@At(value="HEAD")}, cancellable=true)
    private void be_place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext, CallbackInfoReturnable<Boolean> info) {
        if (!GeneratorOptions.hasPortal()) {
            info.setReturnValue((Object)false);
            info.cancel();
        } else if (GeneratorOptions.replacePortal()) {
            RandomSource random = featurePlaceContext.random();
            WorldGenLevel world = featurePlaceContext.level();
            BlockPos blockPos = this.be_updatePortalPos(world);
            String path = this.active ? "portal/end_portal_active" : "portal/end_portal_inactive";
            StructureTemplate structure = StructureHelper.readStructure((ResourceLocation)BetterEnd.C.mk(path));
            Vec3i size = structure.getSize();
            blockPos = blockPos.offset(-(size.getX() >> 1), -3, -(size.getZ() >> 1));
            structure.placeInWorld((ServerLevelAccessor)world, blockPos, blockPos, new StructurePlaceSettings(), random, 2);
            info.setReturnValue((Object)true);
            info.cancel();
        }
    }

    @ModifyVariable(method={"place"}, ordinal=0, at=@At(value="HEAD"), argsOnly=true)
    private FeaturePlaceContext<NoneFeatureConfiguration> be_setPosOnGround(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.level();
        BlockPos pos = this.be_updatePortalPos(world);
        return new FeaturePlaceContext(Optional.empty(), world, featurePlaceContext.chunkGenerator(), featurePlaceContext.random(), pos, (FeatureConfiguration)((NoneFeatureConfiguration)featurePlaceContext.config()));
    }

    @Unique
    private BlockPos be_updatePortalPos(WorldGenLevel world) {
        CompoundTag compound = WorldConfig.getRootTag((ModCore)BetterEnd.C);
        be_portalPosition = NbtUtils.readBlockPos((CompoundTag)compound, (String)"portal").orElse(new BlockPos(0, 0, 0));
        if (be_portalPosition.getY() == 0) {
            int y = world.getHeight(Heightmap.Types.WORLD_SURFACE, 0, 0);
            be_portalPosition = new BlockPos(0, y, 0);
            WorldConfig.getRootTag((ModCore)BetterEnd.C).put("portal", NbtUtils.writeBlockPos((BlockPos)be_portalPosition));
            WorldConfig.saveFile((ModCore)BetterEnd.C);
        }
        return be_portalPosition;
    }
}

