/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.mixin.common;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ChorusPlantFeature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.registry.EndBlocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChorusPlantFeature.class})
public class ChorusPlantFeatureMixin {
    @Inject(method={"place"}, at={@At(value="HEAD")}, cancellable=true)
    private void be_place(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig, CallbackInfoReturnable<Boolean> info) {
        RandomSource random = featureConfig.random();
        BlockPos blockPos = featureConfig.origin();
        WorldGenLevel structureWorldAccess = featureConfig.level();
        if (structureWorldAccess.isEmptyBlock(blockPos) && structureWorldAccess.getBlockState(blockPos.below()).is(EndBlocks.CHORUS_NYLIUM)) {
            ChorusFlowerBlock.generatePlant((LevelAccessor)structureWorldAccess, (BlockPos)blockPos, (RandomSource)random, (int)MHelper.randRange((int)8, (int)16, (RandomSource)random));
            BlockState bottom = structureWorldAccess.getBlockState(blockPos);
            if (bottom.is(Blocks.CHORUS_PLANT)) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)structureWorldAccess, (BlockPos)blockPos, (BlockState)((BlockState)bottom.setValue((Property)PipeBlock.DOWN, (Comparable)Boolean.valueOf(true))));
            }
            info.setReturnValue((Object)true);
        }
    }
}

