/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.mixin.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.betterx.bclib.util.MHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public class MinecraftClientMixin {
    @Shadow
    public LocalPlayer player;
    @Shadow
    public Screen screen;
    @Final
    @Shadow
    public Gui gui;
    @Shadow
    public ClientLevel level;

    @Inject(method={"getSituationalMusic"}, at={@At(value="HEAD")}, cancellable=true)
    private void be_getEndMusic(CallbackInfoReturnable<Music> info) {
        if (!(this.screen instanceof WinScreen) && this.player != null && this.player.level().dimension() == Level.END) {
            if (this.gui.getBossOverlay().shouldPlayMusic() && MHelper.lengthSqr((double)this.player.getX(), (double)this.player.getZ()) < 250000.0) {
                info.setReturnValue((Object)Musics.END_BOSS);
            } else {
                Music sound = ((Biome)this.level.getBiomeManager().getNoiseBiomeAtPosition(this.player.blockPosition()).value()).getBackgroundMusic().orElse(Musics.END);
                info.setReturnValue((Object)sound);
            }
            info.cancel();
        }
    }
}

