/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.item.model;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import org.betterx.bclib.client.render.HumanoidArmorRenderer;
import org.betterx.betterend.registry.EndEntitiesRenders;

public class CrystaliteChestplateModel
extends HumanoidModel<LivingEntity>
implements HumanoidArmorRenderer.CopyExtraState {
    public ModelPart leftShoulder;
    public ModelPart rightShoulder;
    private final boolean thinArms;
    final ModelPart localBody;

    public static LayerDefinition getRegularTexturedModelData() {
        return CrystaliteChestplateModel.getTexturedModelData(1.0f, false);
    }

    public static LayerDefinition getThinTexturedModelData() {
        return CrystaliteChestplateModel.getTexturedModelData(1.0f, true);
    }

    private static LayerDefinition getTexturedModelData(float scale, boolean thinArms) {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        modelPartData.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.ZERO);
        modelPartData.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.ZERO);
        modelPartData.addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.ZERO);
        modelPartData.addOrReplaceChild("left_arm", CubeListBuilder.create(), PartPose.ZERO);
        modelPartData.addOrReplaceChild("right_leg", CubeListBuilder.create(), PartPose.ZERO);
        modelPartData.addOrReplaceChild("left_leg", CubeListBuilder.create(), PartPose.ZERO);
        CubeDeformation deformation = new CubeDeformation(scale + 0.25f);
        PartDefinition body = modelPartData.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, deformation), PartPose.ZERO);
        if (thinArms) {
            deformation = new CubeDeformation(scale + 0.45f);
            PartDefinition leftShoulder = modelPartData.addOrReplaceChild("leftShoulder", CubeListBuilder.create().mirror().texOffs(40, 32).addBox(-1.0f, -2.5f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
            PartDefinition partDefinition = modelPartData.addOrReplaceChild("rightShoulder", CubeListBuilder.create().texOffs(40, 16).addBox(-3.0f, -2.5f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.offset((float)-5.0f, (float)2.0f, (float)10.0f));
        } else {
            deformation = new CubeDeformation(scale + 0.45f);
            PartDefinition leftShoulder = modelPartData.addOrReplaceChild("leftShoulder", CubeListBuilder.create().mirror().texOffs(40, 32).addBox(-1.0f, -2.5f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
            PartDefinition partDefinition = modelPartData.addOrReplaceChild("rightShoulder", CubeListBuilder.create().texOffs(40, 16).addBox(-3.0f, -2.5f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.offset((float)-5.0f, (float)2.0f, (float)10.0f));
        }
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)48);
    }

    public static CrystaliteChestplateModel createRegularModel(EntityModelSet entityModelSet) {
        return new CrystaliteChestplateModel(entityModelSet == null ? CrystaliteChestplateModel.getRegularTexturedModelData().bakeRoot() : entityModelSet.bakeLayer(EndEntitiesRenders.CRYSTALITE_CHESTPLATE), false);
    }

    public static CrystaliteChestplateModel createThinModel(EntityModelSet entityModelSet) {
        return new CrystaliteChestplateModel(entityModelSet == null ? CrystaliteChestplateModel.getThinTexturedModelData().bakeRoot() : entityModelSet.bakeLayer(EndEntitiesRenders.CRYSTALITE_CHESTPLATE_THIN), true);
    }

    protected CrystaliteChestplateModel(ModelPart modelPart, boolean thinArms) {
        super(modelPart, RenderType::entityTranslucent);
        this.thinArms = thinArms;
        this.localBody = modelPart.getChild("body");
        this.leftShoulder = modelPart.getChild("leftShoulder");
        this.rightShoulder = modelPart.getChild("rightShoulder");
    }

    public void copyPropertiesFrom(HumanoidModel<LivingEntity> parentModel) {
        this.leftShoulder.copyFrom(this.leftArm);
        this.rightShoulder.copyFrom(this.rightArm);
    }

    protected Iterable<ModelPart> headParts() {
        return Collections::emptyIterator;
    }

    protected Iterable<ModelPart> bodyParts() {
        return Lists.newArrayList((Object[])new ModelPart[]{this.localBody, this.leftShoulder, this.rightShoulder});
    }

    public void translateToHand(HumanoidArm arm, PoseStack matrices) {
        ModelPart modelPart = this.getArm(arm);
        if (this.thinArms) {
            float f = 0.5f * (float)(arm == HumanoidArm.RIGHT ? 1 : -1);
            modelPart.x += f;
            modelPart.translateAndRotate(matrices);
            modelPart.x -= f;
        } else {
            modelPart.translateAndRotate(matrices);
        }
    }
}

