/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.item.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class ArmoredElytraModel<T extends LivingEntity>
extends AgeableListModel<T> {
    private final ModelPart rightWing;
    private final ModelPart leftWing;

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        modelPartData.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(22, 0).addBox(-10.0f, 0.0f, 0.0f, 10.0f, 20.0f, 2.0f), PartPose.ZERO);
        modelPartData.addOrReplaceChild("right_wing", CubeListBuilder.create().mirror().texOffs(22, 0).addBox(0.0f, 0.0f, 0.0f, 10.0f, 20.0f, 2.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)32);
    }

    public ArmoredElytraModel(ModelPart modelPart) {
        this.leftWing = modelPart.getChild("left_wing");
        this.rightWing = modelPart.getChild("right_wing");
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.leftWing, (Object)this.rightWing);
    }

    public void setupAnim(T livingEntity, float f, float g, float h, float i, float j) {
        float rotX = 0.2617994f;
        float rotZ = -0.2617994f;
        float rotY = 0.0f;
        float wingY = 0.0f;
        if (livingEntity.isFallFlying()) {
            float coef = 1.0f;
            Vec3 vec3 = livingEntity.getDeltaMovement();
            if (vec3.y < 0.0) {
                Vec3 normalized = vec3.normalize();
                coef = 1.0f - (float)Math.pow(-normalized.y, 2.5);
            }
            rotX = coef * 0.34906584f + (1.0f - coef) * rotX;
            rotZ = coef * -1.5707964f + (1.0f - coef) * rotZ;
        } else if (livingEntity.isCrouching()) {
            rotX = 0.6981317f;
            rotZ = -0.7853982f;
            rotY = 0.08726646f;
            wingY = 3.0f;
        }
        this.leftWing.x = 5.0f;
        this.leftWing.y = wingY;
        if (livingEntity instanceof AbstractClientPlayer) {
            AbstractClientPlayer abstractClientPlayer = (AbstractClientPlayer)livingEntity;
            abstractClientPlayer.elytraRotX = (float)((double)abstractClientPlayer.elytraRotX + (double)(rotX - abstractClientPlayer.elytraRotX) * 0.1);
            abstractClientPlayer.elytraRotY = (float)((double)abstractClientPlayer.elytraRotY + (double)(rotY - abstractClientPlayer.elytraRotY) * 0.1);
            abstractClientPlayer.elytraRotZ = (float)((double)abstractClientPlayer.elytraRotZ + (double)(rotZ - abstractClientPlayer.elytraRotZ) * 0.1);
            this.leftWing.xRot = abstractClientPlayer.elytraRotX;
            this.leftWing.yRot = abstractClientPlayer.elytraRotY;
            this.leftWing.zRot = abstractClientPlayer.elytraRotZ;
        } else {
            this.leftWing.xRot = rotX;
            this.leftWing.zRot = rotZ;
            this.leftWing.yRot = rotY;
        }
        this.rightWing.x = -this.leftWing.x;
        this.rightWing.yRot = -this.leftWing.yRot;
        this.rightWing.y = this.leftWing.y;
        this.rightWing.xRot = this.leftWing.xRot;
        this.rightWing.zRot = -this.leftWing.zRot;
    }
}

